/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class SSOException
extends Exception {
    private static final long serialVersionUID = -8507311578565700705L;
    private static ResourceBundle resourceBundle = null;
    private int reasonCode;
    private String faultCode;
    private String faultString;

    public SSOException(int reasonCode, String faultCode, Object[] args) {
        super(SSOException.getMessage(faultCode, args));
        this.reasonCode = reasonCode;
        this.faultCode = this.getFaultCode(faultCode);
        this.faultString = SSOException.getMessage(faultCode, args);
    }

    public SSOException(int reasonCode, String faultCode) {
        this(reasonCode, faultCode, (Object[])null);
    }

    public SSOException(int reasonCode, String faultCode, Object[] args, Throwable e) {
        super(SSOException.getMessage(faultCode, args), e);
        this.reasonCode = reasonCode;
        this.faultCode = faultCode;
        this.faultString = SSOException.getMessage(faultCode, args);
    }

    public SSOException(int reasonCode, String faultCode, Throwable e) {
        this(reasonCode, faultCode, null, e);
    }

    public SSOException(String faultCode, Object[] args) {
        super(SSOException.getMessage(faultCode, args));
        this.faultCode = this.getFaultCode(faultCode);
        this.faultString = SSOException.getMessage(faultCode, args);
    }

    public SSOException(String faultCode) {
        this(faultCode, (Object[])null);
    }

    public SSOException(String faultCode, Object[] args, Throwable e) {
        super(SSOException.getMessage(faultCode, args), e);
        this.faultCode = faultCode;
        this.faultString = SSOException.getMessage(faultCode, args);
    }

    public SSOException(String faultCode, Throwable e) {
        this(faultCode, null, e);
    }

    protected static String getMessage(String faultCode, Object[] args) {
        String msg = null;
        if (resourceBundle != null) {
            try {
                msg = MessageFormat.format(resourceBundle.getString(faultCode), args);
            }
            catch (MissingResourceException e) {
                throw new RuntimeException("Undefined '" + faultCode + "' resource property");
            }
        }
        if (msg != null) {
            return msg;
        }
        if (args != null) {
            return MessageFormat.format(faultCode, args);
        }
        return faultCode;
    }

    private String getFaultCode(String code) {
        return code;
    }

    protected String getFaultCode() {
        return this.faultCode;
    }

    protected String getFaultString() {
        return this.faultString;
    }

    public int getReasonCode() {
        return this.reasonCode;
    }

    static {
        try {
            resourceBundle = ResourceBundle.getBundle("org.eclipse.alf.sso.errors");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

