/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http.configuration;

import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.http.configuration.PKIConfigData;

public class PrincipalEndorsmentConfig {
    static final Logger log = Logger.getLogger(PrincipalEndorsmentConfig.class);
    public static final int PRINCIPAL_ENDORSMENT_METHOD_UNKNOWN = 0;
    public static final int PRINCIPAL_ENDORSMENT_METHOD_USERNAMETOKEN = 1;
    public static final int PRINCIPAL_ENDORSMENT_METHOD_X509CERTINSIG = 2;
    public static final int PRINCIPAL_ENDORSMENT_METHOD_ALL_SUPPORTED = 3;
    private int type = 0;
    private String username = null;
    private String password = null;
    private PKIConfigData signatureConfig = null;

    public PrincipalEndorsmentConfig() {
        this.reset();
    }

    public PrincipalEndorsmentConfig(String username, String password) {
        this.type = 1;
        this.username = username;
        this.password = password;
    }

    public PrincipalEndorsmentConfig(PKIConfigData signatureConfig) {
        this.type = 2;
        this.signatureConfig = signatureConfig;
    }

    public PrincipalEndorsmentConfig(String keystoreId, String certAlias, String certPassword) {
        this.type = 2;
        this.signatureConfig.setKeystoreId(keystoreId);
        this.signatureConfig.setCertAlias(certAlias);
        this.signatureConfig.setSigningCertPassword(certPassword);
    }

    public PrincipalEndorsmentConfig(PrincipalEndorsmentConfig other) {
        this.type = other.type;
        this.username = other.username;
        this.signatureConfig = other.signatureConfig != null ? (PKIConfigData)this.signatureConfig.clone() : null;
    }

    public void reset() {
        this.username = null;
        this.password = null;
        this.signatureConfig = null;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getKeystoreId() {
        if (this.signatureConfig != null) {
            return this.signatureConfig.getKeystoreId();
        }
        return null;
    }

    public void setKeystoreId(String keystoreId) {
        if (this.signatureConfig == null) {
            this.signatureConfig = new PKIConfigData();
        }
        this.signatureConfig.setKeystoreId(keystoreId);
    }

    public String getSigningCertPassword() {
        if (this.signatureConfig != null) {
            return this.signatureConfig.getSigningCertPassword();
        }
        return null;
    }

    public void setSigningCertPassword(String signingCertPassword) {
        if (this.signatureConfig == null) {
            this.signatureConfig = new PKIConfigData();
        }
        this.signatureConfig.setSigningCertPassword(signingCertPassword);
    }

    public String getCertAlias() {
        if (this.signatureConfig != null) {
            return this.signatureConfig.getCertAlias();
        }
        return null;
    }

    public void setCertAlias(String certAlias) {
        if (this.signatureConfig == null) {
            this.signatureConfig = new PKIConfigData();
        }
        this.signatureConfig.setCertAlias(certAlias);
    }

    public String getCertInclusionMethod() {
        if (this.signatureConfig != null) {
            return this.signatureConfig.getCertInclusionMethod();
        }
        return null;
    }

    public void setCertInclusionMethod(String certInclusionMethod) {
        if (this.signatureConfig == null) {
            this.signatureConfig = new PKIConfigData();
        }
        this.signatureConfig.setCertInclusionMethod(certInclusionMethod);
    }

    public PKIConfigData getSignatureConfig() {
        return this.signatureConfig;
    }

    public void setSignatureConfig(PKIConfigData signatureConfig) {
        this.signatureConfig = signatureConfig;
    }

    public Object clone() {
        return new PrincipalEndorsmentConfig(this);
    }
}

