/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http.configuration.builder;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.PKIConfig;
import org.eclipse.alf.security.sso.common.http.configuration.PKIConfigData;
import org.eclipse.alf.security.sso.common.http.configuration.PrincipalEndorsmentConfig;
import org.eclipse.alf.security.sso.common.http.configuration.builder.PKIConfigDataBuilder;
import org.eclipse.alf.security.sso.common.http.configuration.builder.SecretElementBuilder;
import org.eclipse.alf.security.sso.common.util.StringHelper;

public class PrincipalEndorsmentConfigBuilder {
    private static final Logger log = Logger.getLogger(PrincipalEndorsmentConfigBuilder.class);
    public static final String PRINCIPAL_ENDORSMENT_METHODS_LN = "PrincipalEndorsmentMethods";
    public static final String USERNAME_CREDENTIAL_LN = "UsernameCredential";
    public static final String USERNAME_LN = "Username";
    public static final String PASSWORD_LN = "Password";
    public static final String X509CERTSIGNATURE_CREDENTIAL_LN = "X509CertificateSignature";
    public static final String RELYING_PARTY_SIGNATURE_CONFIG_LN = "RelyingPartySignatureConfig";
    public static final String RELYING_PARTY_ENCRYPTION_CONFIG_LN = "RelyingPartyEncryptionConfig";
    public static final String APPLICATION_SIGNATURE_CONFIG_LN = "ApplicationSignatureConfig";
    public static final String APPLICATION_ENCRYPTION_CONFIG_LN = "ApplicationEncryptionConfig";

    public PrincipalEndorsmentConfigBuilder() {
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public PrincipalEndorsmentConfig build(OMElement element, PKIConfig applicationPKIConfig, PKIConfig rpPKIConfig) {
        OMElement signatureCredentialEl;
        PrincipalEndorsmentConfig retVal = new PrincipalEndorsmentConfig();
        if (element == null) {
            return retVal;
        }
        if (!element.getLocalName().equals(PRINCIPAL_ENDORSMENT_METHODS_LN)) {
            log.error((Object)("Invalid configuration element <" + element.getLocalName() + "> when expectin <" + PRINCIPAL_ENDORSMENT_METHODS_LN + ">"));
            return null;
        }
        OMElement usernameCredentialEl = element.getFirstChildWithName(new QName(USERNAME_CREDENTIAL_LN));
        if (usernameCredentialEl != null) {
            retVal.setType(1);
            OMElement usernameEl = usernameCredentialEl.getFirstChildWithName(new QName(USERNAME_LN));
            String username = null;
            if (usernameEl != null) {
                username = usernameEl.getText().trim();
            }
            OMElement passwordEl = usernameCredentialEl.getFirstChildWithName(new QName(PASSWORD_LN));
            String password = null;
            if (passwordEl != null) {
                SecretElementBuilder secretElementBuilder = new SecretElementBuilder();
                try {
                    password = secretElementBuilder.parse(passwordEl);
                }
                catch (SSOException e) {
                    return null;
                }
            }
            if (StringHelper.isBlank(username)) {
                log.error((Object)"Username empty in endorsing credentials configuration, skipping configuration");
            } else {
                if (StringHelper.isEmpty(password)) {
                    password = "";
                }
                retVal.setUsername(username);
                retVal.setPassword(password);
                retVal.setType(1);
            }
        }
        if ((signatureCredentialEl = element.getFirstChildWithName(new QName(X509CERTSIGNATURE_CREDENTIAL_LN))) != null) {
            PKIConfigData signatureConfig = null;
            PKIConfigDataBuilder signatureConfigDataBuilder = new PKIConfigDataBuilder();
            Iterator it = signatureCredentialEl.getChildElements();
            while (it != null && it.hasNext()) {
                OMElement currentEl = (OMElement)it.next();
                if (currentEl.getLocalName().equals(APPLICATION_SIGNATURE_CONFIG_LN)) {
                    signatureConfig = signatureConfigDataBuilder.build(currentEl, applicationPKIConfig.getOutflowSignatureConfig());
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Using application signature configuration");
                    continue;
                }
                if (currentEl.getLocalName().equals(RELYING_PARTY_SIGNATURE_CONFIG_LN)) {
                    signatureConfig = signatureConfigDataBuilder.build(currentEl, rpPKIConfig.getOutflowSignatureConfig());
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Using relying party signature configuration");
                    continue;
                }
                if (currentEl.getLocalName().equals("SignatureConfig")) {
                    signatureConfig = signatureConfigDataBuilder.build(currentEl, null);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Built signature configuration object");
                    continue;
                }
                log.info((Object)("<" + currentEl.getLocalName() + "> element is unknown."));
            }
            if (signatureConfig != null && StringHelper.isNotBlank(signatureConfig.getKeystoreId()) && StringHelper.isNotBlank(signatureConfig.getCertAlias()) && StringHelper.isNotBlank(signatureConfig.getSigningCertPassword()) && StringHelper.isNotBlank(signatureConfig.getCertInclusionMethod())) {
                retVal.setSignatureConfig(signatureConfig);
                if (retVal.getType() == 1) {
                    retVal.setType(3);
                } else {
                    retVal.setType(2);
                }
            }
        }
        return retVal;
    }
}

