/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http.configuration.builder;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOConfigSecretDataCallback;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.util.XMLHelper;

public class SecretElementBuilder {
    private static final Logger log = Logger.getLogger(SecretElementBuilder.class);
    public static final String SECRET_PARAM_ID_ATTR = "id";
    public static final String SECRET_PARAM_VALUE_PROPERTY_NAME_ATTR = "valuePropertyName";
    public static final String SECRET_PARAM_VALUE_CALLBACK_ATTR = "valueCallback";

    public String parse(OMElement el) throws SSOException {
        if (el == null) {
            return null;
        }
        String value = null;
        String id = XMLHelper.getAttribute(el, SECRET_PARAM_ID_ATTR);
        String property = XMLHelper.getAttribute(el, SECRET_PARAM_VALUE_PROPERTY_NAME_ATTR);
        String callbackClassName = XMLHelper.getAttribute(el, SECRET_PARAM_VALUE_CALLBACK_ATTR);
        boolean valueAquired = false;
        if (StringHelper.isNotBlank(callbackClassName)) {
            if (StringHelper.isNotBlank(id)) {
                CallbackHandler cbHandler = null;
                ClassLoader classLoader = this.getClass().getClassLoader();
                log.debug((Object)("loading class : " + callbackClassName));
                try {
                    Class<?> cbClass = null;
                    cbClass = classLoader.loadClass(callbackClassName);
                    if (cbClass != null) {
                        cbHandler = (CallbackHandler)cbClass.newInstance();
                    }
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)("Failed to load class \"" + callbackClassName + "\" : class not found"));
                    return null;
                }
                catch (Exception e) {
                    log.error((Object)("Error while trying to load class \"" + callbackClassName + "\""), (Throwable)e);
                    return null;
                }
                Callback[] callbacks = new Callback[]{new SSOConfigSecretDataCallback(id, 2)};
                try {
                    cbHandler.handle(callbacks);
                }
                catch (IOException e) {
                    log.error((Object)"Failed to extract secret value from callback. Skipping.", (Throwable)e);
                    return null;
                }
                catch (UnsupportedCallbackException e) {
                    log.error((Object)"Unsupported callback exception was caught while handling secret property value callback", (Throwable)e);
                    return null;
                }
                value = ((SSOConfigSecretDataCallback)callbacks[0]).getSecret();
                valueAquired = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Set secret parameter value returned from callback class \"" + callbackClassName + "\""));
                }
            } else {
                log.error((Object)"Secret Data element contains an @valueCallback attribute but @id is not present. Cannot call callback with parameteridentifing attribute.");
                return null;
            }
        }
        if (!valueAquired && StringHelper.isNotBlank(property)) {
            try {
                value = System.getProperty(property);
                valueAquired = true;
            }
            catch (SecurityException e) {
                log.error((Object)"Security exception caught while trying to access system property");
                throw new SSOException("Security exception caught while trying to access system property", e);
            }
        }
        if (!valueAquired) {
            value = el.getText();
        }
        return value;
    }
}

