/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http.configuration.matcher;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.RPURI;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.AbstractMatcher;
import org.eclipse.alf.security.sso.common.util.StringHelper;

public class RPURIMatcher
extends AbstractMatcher {
    private static final Logger log = Logger.getLogger(RPURIMatcher.class);
    public static final String DEFAULT_REGEX_STRING = "*";
    public static final String DEFAULT_REGEX_STRING_JAVAREGEX = ".*";
    protected String regexType;
    protected String regexRealm;
    protected String regexInstance;
    protected Pattern regexTypePattern;
    protected Pattern regexRealmPattern;
    protected Pattern regexInstancePattern;

    public RPURIMatcher() {
        this.reset();
    }

    public RPURIMatcher(int matcherType) {
        super(matcherType);
        this.reset();
    }

    public RPURIMatcher(int matcherType, String regexType, String regexRealm, String regexInstance) throws SSOException {
        super(matcherType);
        this.reset();
        this.setRegexType(regexType);
        this.setRegexRealm(regexRealm);
        this.setRegexInstance(regexInstance);
    }

    public void reset() {
        if (this.matcherType == 2) {
            try {
                this.regexType = DEFAULT_REGEX_STRING_JAVAREGEX;
                this.regexRealm = DEFAULT_REGEX_STRING_JAVAREGEX;
                this.regexInstance = DEFAULT_REGEX_STRING_JAVAREGEX;
                this.regexTypePattern = Pattern.compile(this.regexType);
                this.regexRealmPattern = Pattern.compile(this.regexRealm);
                this.regexInstancePattern = Pattern.compile(this.regexInstance);
            }
            catch (PatternSyntaxException patternSyntaxException) {}
        } else if (this.matcherType == 1) {
            this.regexType = DEFAULT_REGEX_STRING;
            this.regexRealm = DEFAULT_REGEX_STRING;
            this.regexInstance = DEFAULT_REGEX_STRING;
        } else {
            throw new RuntimeException("Invalid matcher type:" + this.matcherType);
        }
    }

    public boolean isMatchAllMatcher() {
        String defaultPattern = this.matcherType == 2 ? DEFAULT_REGEX_STRING_JAVAREGEX : DEFAULT_REGEX_STRING;
        return this.regexType.equals(defaultPattern) && this.regexRealm.equals(defaultPattern) && this.regexInstance.equals(defaultPattern);
    }

    public boolean matches(String type, String realm, String instance) {
        if (this.matcherType == 2) {
            this.matchScore = null;
            Matcher typeMatcher = this.regexTypePattern.matcher(type);
            Matcher realmMatcher = this.regexRealmPattern.matcher(realm);
            Matcher instanceMatcher = this.regexInstancePattern.matcher(instance);
            return typeMatcher != null && realmMatcher != null && instanceMatcher != null && typeMatcher.matches() && realmMatcher.matches() && instanceMatcher.matches();
        }
        if (this.matcherType == 1) {
            int typeMatchScore = StringHelper.basicWildcardMatchWithMatchScore(this.regexType, type);
            int realmMatchScore = StringHelper.basicWildcardMatchWithMatchScore(this.regexRealm, realm);
            int instanceMatchScore = StringHelper.basicWildcardMatchWithMatchScore(this.regexInstance, instance);
            boolean matches = typeMatchScore >= 0 && realmMatchScore >= 0 && instanceMatchScore >= 0;
            this.matchScore = matches ? new Long(typeMatchScore * 100 + realmMatchScore * 10 + instanceMatchScore) : new Long(-1L);
            return matches;
        }
        throw new RuntimeException("Invalid matcher type: \"" + this.matcherType + "\"");
    }

    public String getRegexType() {
        return this.regexType;
    }

    public void setRegexType(String regexType) throws SSOException {
        this.regexType = StringHelper.isBlank(regexType) ? DEFAULT_REGEX_STRING : regexType;
        if (this.matcherType == 2) {
            try {
                this.regexTypePattern = Pattern.compile(regexType);
            }
            catch (PatternSyntaxException e) {
                String errorString = "Invalid pattern while trying to set RPURI type regex: " + regexType;
                log.error((Object)errorString, (Throwable)e);
                throw new SSOException(errorString, e);
            }
        }
    }

    public String getRegexRealm() {
        return this.regexRealm;
    }

    public void setRegexRealm(String regexRealm) throws SSOException {
        this.regexRealm = StringHelper.isBlank(regexRealm) ? DEFAULT_REGEX_STRING : regexRealm;
        if (this.matcherType == 2) {
            try {
                this.regexRealmPattern = Pattern.compile(regexRealm);
            }
            catch (PatternSyntaxException e) {
                String errorString = "Invalid pattern while trying to set RPURI realm regex: " + regexRealm;
                log.error((Object)errorString, (Throwable)e);
                throw new SSOException(errorString, e);
            }
        }
    }

    public String getRegexInstance() {
        return this.regexInstance;
    }

    public void setRegexInstance(String regexInstance) throws SSOException {
        this.regexInstance = StringHelper.isBlank(regexInstance) ? DEFAULT_REGEX_STRING : regexInstance;
        if (this.matcherType == 2) {
            try {
                this.regexInstancePattern = Pattern.compile(regexInstance);
            }
            catch (PatternSyntaxException e) {
                String errorString = "Invalid pattern while trying to set RPURI instance regex: " + regexInstance;
                log.error((Object)errorString, (Throwable)e);
                throw new SSOException(errorString, e);
            }
        }
    }

    public static int calculateMatchExpressionsHash(String realm, String type, String instance) {
        return (realm + type + instance).hashCode();
    }

    public String toString() {
        return RPURI.createRPURI(this.regexType, this.regexRealm, this.regexInstance).toString();
    }
}

