/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.policy.builder;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.token.saml.policy.BasePolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.SubjectConfirmationPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.builder.BasePolicyBuilder;
import org.eclipse.alf.security.sso.common.util.SSOHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;

public class SubjectConfirmationPolicyBuilder
extends BasePolicyBuilder {
    private static final Logger log = Logger.getLogger(SubjectConfirmationPolicyBuilder.class);
    public static final String SUBJECT_CONFIRMATION_POLICY_LN = "SubjectConfirmationPolicy";
    public static final String ALLOWED_CONFIRMATION_METHOD_LN = "AllowedConfirmationMethod";

    public String getLocalName() {
        return SUBJECT_CONFIRMATION_POLICY_LN;
    }

    public BasePolicy build(OMElement element) throws SSOException {
        return this.build(element, null);
    }

    public BasePolicy build(OMElement element, BasePolicy basePolicy) throws SSOException {
        if (element == null) {
            log.warn((Object)"SubjectConfirmationPolicyBuilder.build(null) called");
            return basePolicy;
        }
        OMElement el = element.getFirstChildWithName(new QName(this.getLocalName()));
        if (el == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"SubjectConfirmationPolicyBuilder.build(): policy local name not found");
            }
            return basePolicy;
        }
        SubjectConfirmationPolicy subjectConfirmationPolicy = null;
        subjectConfirmationPolicy = basePolicy != null ? (SubjectConfirmationPolicy)basePolicy.clone() : new SubjectConfirmationPolicy();
        if (SSOHelper.toBoolean(this.getAttribute(el, "override"), subjectConfirmationPolicy.getOverride())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"SubjectConfirmationPolicyBuilder.build(): Overriding previously defined policy");
            }
            subjectConfirmationPolicy = new SubjectConfirmationPolicy();
        }
        subjectConfirmationPolicy.setEnforced(SSOHelper.toBoolean(this.getAttribute(el, "enforce"), subjectConfirmationPolicy.getEnforced()));
        Iterator allowedConfirmationMethodsIt = el.getChildrenWithName(new QName(ALLOWED_CONFIRMATION_METHOD_LN));
        if (allowedConfirmationMethodsIt != null) {
            while (allowedConfirmationMethodsIt.hasNext()) {
                OMElement next = (OMElement)allowedConfirmationMethodsIt.next();
                String cm = next.getText().trim();
                if (StringHelper.isNotBlank(cm)) {
                    subjectConfirmationPolicy.addAllowedConformationMethods(cm);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Added \"" + cm + "\" to the list of allowed subject confirmation methods"));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Empty subject confirmation method value encountered");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Missing <AllowedConfirmationMethod> elements in policy");
        }
        return subjectConfirmationPolicy;
    }
}

