/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.policy.validator;

import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ExtendedResult;
import org.eclipse.alf.security.sso.common.token.SSOTokenValidationResult;
import org.eclipse.alf.security.sso.common.token.saml.SAML1Handler;
import org.eclipse.alf.security.sso.common.token.saml.policy.BasePolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.ExpirationPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.SAML1Policy;
import org.eclipse.alf.security.sso.common.token.saml.policy.validator.AudienceRestrictionPolicyValidator;
import org.eclipse.alf.security.sso.common.token.saml.policy.validator.AuthorityBindingPolicyValidator;
import org.eclipse.alf.security.sso.common.token.saml.policy.validator.BasePolicyValidator;
import org.eclipse.alf.security.sso.common.token.saml.policy.validator.ClaimsPolicyValidator;
import org.eclipse.alf.security.sso.common.token.saml.policy.validator.ExpirationPolicyValidator;
import org.eclipse.alf.security.sso.common.token.saml.policy.validator.NameIdentifierPolicyValidator;
import org.eclipse.alf.security.sso.common.token.saml.policy.validator.SubjectConfirmationPolicyValidator;
import org.eclipse.alf.security.sso.common.token.saml.policy.validator.TrustPolicyValidator;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;

public class SAML1PolicyValidatorImpl
extends BasePolicyValidator {
    private static final Logger log = Logger.getLogger(SAML1PolicyValidatorImpl.class);
    private TrustPolicyValidator trustPolicyValidator = new TrustPolicyValidator();
    private NameIdentifierPolicyValidator nameIdentifierPolicyValidator = new NameIdentifierPolicyValidator();
    private ExpirationPolicyValidator expirationPolicyValidator = new ExpirationPolicyValidator();
    private SubjectConfirmationPolicyValidator subjectConfirmationPolicyValidator = new SubjectConfirmationPolicyValidator();
    private AudienceRestrictionPolicyValidator audienceRestrictionPolicyValidator = new AudienceRestrictionPolicyValidator();
    private AuthorityBindingPolicyValidator authorityBindingPolicyValidator = new AuthorityBindingPolicyValidator();
    private ClaimsPolicyValidator claimsPolicyValidator = new ClaimsPolicyValidator();

    public ExtendedResult validate(SAML1Handler samlHandler, BasePolicy samlPolicy) {
        ExtendedResult result;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering SAML profile policy validation");
        }
        if (!(result = this.validateSignature(samlHandler)).isSuccess()) {
            return result;
        }
        result = this.validateSignature(samlHandler);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.validatePolicy(samlPolicy);
        if (!result.isSuccess()) {
            return result;
        }
        SAML1Policy policy = (SAML1Policy)samlPolicy;
        if (policy.getTrustPolicy().getEnforced() && !(result = this.trustPolicyValidator.validate(samlHandler, policy.getTrustPolicy())).isSuccess()) {
            return result;
        }
        if (policy.getNameIdentifierPolicy().getEnforced() && !(result = this.nameIdentifierPolicyValidator.validate(samlHandler, policy.getNameIdentifierPolicy())).isSuccess()) {
            return result;
        }
        if (policy.getExpirationPolicy().getEnforced() && !(result = this.expirationPolicyValidator.validate(samlHandler, policy.getExpirationPolicy())).isSuccess()) {
            return result;
        }
        if (policy.getSubjectConfirmationPolicy().getEnforced() && !(result = this.subjectConfirmationPolicyValidator.validate(samlHandler, policy.getSubjectConfirmationPolicy())).isSuccess()) {
            return result;
        }
        if (policy.getAudienceRestrictionPolicy().getEnforced() && !(result = this.audienceRestrictionPolicyValidator.validate(samlHandler, policy.getAudienceRestrictionPolicy())).isSuccess()) {
            return result;
        }
        if (policy.getAuthorityBindingPolicy().getEnforced() && !(result = this.authorityBindingPolicyValidator.validate(samlHandler, policy.getAuthorityBindingPolicy())).isSuccess()) {
            return result;
        }
        if (policy.getClaimsPolicy().getEnforced() && !(result = this.claimsPolicyValidator.validate(samlHandler, policy.getClaimsPolicy())).isSuccess()) {
            return result;
        }
        result = new SSOTokenValidationResult();
        result.setCode(0);
        return result;
    }

    public ExtendedResult validateExpiration(SAML1Handler samlHandler, BasePolicy policy) {
        SAML1Policy samlPolicy = (SAML1Policy)policy;
        ExpirationPolicy expirationPolicy = samlPolicy.getExpirationPolicy();
        return this.expirationPolicyValidator.validate(samlHandler, expirationPolicy);
    }

    public ExtendedResult validateHandler(SAML1Handler handler) {
        SSOTokenValidationResult result = new SSOTokenValidationResult();
        if (handler == null) {
            result.setCode(200);
            return result;
        }
        result.setCode(0);
        return result;
    }

    public ExtendedResult validatePolicy(BasePolicy policy) {
        SSOTokenValidationResult result = new SSOTokenValidationResult();
        if (policy == null) {
            result.setCode(180);
            return result;
        }
        if (!(policy instanceof SAML1Policy)) {
            result.setCode(190);
            return result;
        }
        result.setCode(0);
        return result;
    }

    public ExtendedResult validateSignature(SAML1Handler samlHandler) {
        SSOTokenValidationResult result = new SSOTokenValidationResult();
        SAMLAssertion assertion = (SAMLAssertion)samlHandler.getNativeObject();
        if (!assertion.isSigned()) {
            log.debug((Object)"SAML validation: assertion is not signed");
            result.setCode(80);
            return result;
        }
        try {
            assertion.verify();
        }
        catch (SAMLException e) {
            result.setCode(90);
            return result;
        }
        result.setCode(0);
        return result;
    }
}

