/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class FileIOHelper {
    private static final Logger log = Logger.getLogger(FileIOHelper.class);

    public static String normalizePath(String path) {
        int index2;
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        while (normalized.indexOf("//") >= 0) {
            normalized = normalized.replace("//", "/");
        }
        while ((index = normalized.indexOf("/../")) >= 0 && index != 0 && (index2 = normalized.lastIndexOf(47, index - 1)) != -1) {
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    public static String resolveFilepath(String basePath, String name) {
        if ((name = FileIOHelper.normalizePath(name)) == null) {
            return null;
        }
        if (ClassLoader.getSystemResource(name) != null) {
            return name;
        }
        File resFile = new File(name);
        if (resFile.isFile()) {
            return FileIOHelper.normalizePath(resFile.getAbsolutePath());
        }
        if (basePath != null) {
            basePath = FileIOHelper.normalizePath(basePath + "/" + name);
        }
        if (basePath != null && (resFile = new File(basePath)).isFile()) {
            return FileIOHelper.normalizePath(resFile.getAbsolutePath());
        }
        return null;
    }

    public static InputStream loadResource(String basePath, String name) {
        if (name == null) {
            return null;
        }
        InputStream is = ClassLoader.getSystemResourceAsStream(name = FileIOHelper.normalizePath(name));
        if (is != null) {
            return is;
        }
        File resFile = new File(name);
        if (resFile.isFile()) {
            try {
                is = new FileInputStream(resFile);
                return is;
            }
            catch (FileNotFoundException e) {
            }
            catch (SecurityException e) {
                return null;
            }
        }
        if (basePath != null) {
            basePath = FileIOHelper.normalizePath(basePath + "/" + name);
        }
        if (basePath != null && (resFile = new File(basePath)).isFile()) {
            try {
                is = new FileInputStream(resFile);
                return is;
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (SecurityException e) {
                return null;
            }
        }
        return null;
    }

    static {
        log.isDebugEnabled();
    }
}

