/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.trust.element.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.GenericAttribute;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrust;
import org.eclipse.alf.security.sso.common.ws.model.trust.custom.alf.WSTrustAlfClaimsObjectBuilder;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.Claims;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.BaseWSTrustObjectImpl;

public class ClaimsImpl
extends BaseWSTrustObjectImpl
implements Claims {
    private static final Logger log = Logger.getLogger(ClaimsImpl.class);
    protected WSTrust wst;
    protected String dialect;
    protected ArrayList claims;

    public ClaimsImpl() {
        this.reset();
        this.wst = new WSTrust();
    }

    public ClaimsImpl(WSTrust wst) {
        this.reset();
        this.wst = wst;
    }

    public String getLocalName() {
        return "Claims";
    }

    public void reset() {
        super.reset();
        this.dialect = null;
        this.claims = new ArrayList();
    }

    public void copyFrom(BaseWSInterface other) {
        super.copyFrom(other);
        if (other instanceof ClaimsImpl) {
            ClaimsImpl otherClaimsImpl = (ClaimsImpl)other;
            this.wst = otherClaimsImpl.wst;
            this.dialect = otherClaimsImpl.dialect;
            this.claims = otherClaimsImpl.claims;
        }
    }

    public void setDialectAttribute(String dialect) {
        this.dialect = dialect;
        this.setDirty();
    }

    public String getDialectAttribute() {
        return this.dialect;
    }

    public void addClaim(BaseWSInterface claim) {
        this.claims.add(claim);
        this.setDirty();
    }

    public Iterator getClaims() {
        return this.claims.iterator();
    }

    public OMElement toOM() {
        return this.toOM(null);
    }

    public OMElement toOM(OMElement parent) {
        Iterator it;
        if (!this.isParseSourceDirty()) {
            if (parent != null) {
                parent.addChild((OMNode)this.getParseSource());
            }
            return this.getParseSource();
        }
        OMElement claimsEl = this.wst.createOMElement(parent, this.getLocalName());
        OMAttribute attrDialect = null;
        if (this.dialect != null) {
            OMNamespace wstns = this.wst.getOMNamespace();
            attrDialect = OMAbstractFactory.getOMFactory().createOMAttribute("Dialect", wstns, this.dialect);
            claimsEl.addAttribute(attrDialect);
        }
        if ((it = this.claims.iterator()) != null) {
            while (it.hasNext()) {
                BaseWSInterface obj = (BaseWSInterface)it.next();
                obj.toOM(claimsEl);
            }
        }
        this.addAnyAttributesToElement(claimsEl);
        this.addAnyElementsToElementAsChildren(claimsEl);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created " + this.getLocalName() + " object:[" + claimsEl.toString() + "]"));
        }
        return claimsEl;
    }

    public boolean isCompatibleElement(OMElement element) throws SSOException {
        return this.baseIsCompatibleElementTrust(element, this.getLocalName()) != null;
    }

    public BaseWSInterface fromOM(OMElement element) throws SSOException {
        WSTrust wst = this.baseIsCompatibleElementTrust(element, this.getLocalName());
        if (wst == null) {
            return null;
        }
        log.debug((Object)"Building <wst:Claims> object from OMElement");
        ClaimsImpl claims = new ClaimsImpl(wst);
        Iterator it = element.getAllAttributes();
        if (it != null) {
            while (it.hasNext()) {
                OMAttribute attr = (OMAttribute)it.next();
                if (attr.getNamespace().getNamespaceURI().equals(wst.getNamespace()) && attr.getLocalName().equals("Dialect")) {
                    claims.setDialectAttribute(attr.getAttributeValue());
                    continue;
                }
                claims._anyAttr.add(new GenericAttribute(attr.getLocalName(), attr.getAttributeValue()));
            }
        }
        if ((it = element.getChildElements()) != null) {
            while (it.hasNext()) {
                OMElement workEl = (OMElement)it.next();
                String ns = workEl.getNamespace().getNamespaceURI();
                String localName = workEl.getLocalName();
                if (ns.equals("http://www.eclipse.org/ALF/1.0/claims")) {
                    if ("Claim".equals(localName)) {
                        claims.addClaim(WSTrustAlfClaimsObjectBuilder.buildClaim(workEl));
                        continue;
                    }
                    claims._anyElement.add(workEl.cloneOMElement());
                    continue;
                }
                claims._anyElement.add(workEl.cloneOMElement());
            }
        }
        claims.setParseSource(element);
        this.copyFrom(claims);
        return this;
    }

    public WSTrust getWSTrust() {
        return this.wst;
    }
}

