/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.trust.element.impl;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrust;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestType;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.BaseWSTrustObjectImpl;

public class RequestTypeImpl
extends BaseWSTrustObjectImpl
implements RequestType {
    private static final Logger log = Logger.getLogger(RequestTypeImpl.class);
    protected WSTrust wst;
    protected String requestType;

    public RequestTypeImpl() {
        this.reset();
        this.wst = new WSTrust();
    }

    public RequestTypeImpl(WSTrust wst) {
        this.reset();
        this.wst = wst;
    }

    public RequestTypeImpl(WSTrust wst, String requestType) {
        this.wst = wst;
        this.requestType = requestType;
    }

    public String getLocalName() {
        return "RequestType";
    }

    public void reset() {
        super.reset();
        this.requestType = null;
    }

    public void copyFrom(BaseWSInterface other) {
        super.copyFrom(other);
        if (other instanceof RequestTypeImpl) {
            RequestTypeImpl otherRequestTypeImpl = (RequestTypeImpl)other;
            this.wst = otherRequestTypeImpl.wst;
            this.requestType = otherRequestTypeImpl.requestType;
        }
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
        this.setDirty();
    }

    public boolean isKnownRequestType() {
        if (this.requestType.equals(this.wst.RequestTypes.getIssue())) {
            return true;
        }
        if (this.requestType.equals(this.wst.RequestTypes.getRenew())) {
            return true;
        }
        if (this.requestType.equals(this.wst.RequestTypes.getCancel())) {
            return true;
        }
        return this.requestType.equals(this.wst.RequestTypes.getValidate());
    }

    public OMElement toOM() {
        return this.toOM(null);
    }

    public OMElement toOM(OMElement parent) {
        if (!this.isParseSourceDirty()) {
            if (parent != null) {
                parent.addChild((OMNode)this.getParseSource());
            }
            return this.getParseSource();
        }
        OMElement requestTypeEl = this.wst.createOMElement(parent, this.getLocalName());
        if (this.requestType != null) {
            requestTypeEl.setText(this.requestType);
        }
        this.addAnyAttributesToElement(requestTypeEl);
        this.addAnyElementsToElementAsChildren(requestTypeEl);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created " + this.getLocalName() + " object:[" + requestTypeEl.toString() + "]"));
        }
        return requestTypeEl;
    }

    public boolean isCompatibleElement(OMElement element) throws SSOException {
        return this.baseIsCompatibleElementTrust(element, this.getLocalName()) != null;
    }

    public BaseWSInterface fromOM(OMElement element) throws SSOException {
        WSTrust wst = this.baseIsCompatibleElementTrust(element, this.getLocalName());
        if (wst == null) {
            return null;
        }
        log.debug((Object)"Parsing <wst:RequestType>");
        RequestTypeImpl requestType = new RequestTypeImpl(wst);
        requestType.setRequestType(element.getText());
        requestType.setParseSource(element);
        this.copyFrom(requestType);
        return this;
    }

    public WSTrust getWSTrust() {
        return this.wst;
    }
}

