/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.editors.eventregistry;

import java.io.File;
import org.eclipse.alf.editors.eventregistry.EditEventRegistration;
import org.eclipse.alf.editors.eventregistry.EventEditor;
import org.eclipse.alf.editors.eventregistry.MySelectionAdapter;
import org.eclipse.alf.models.RegisteredEvent;
import org.eclipse.alf.util.ArrayManager;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RegisterEventScreen
extends ApplicationWindow {
    private Group composite;
    private Composite container;
    private Text txtEvtMatch;
    private Text txtEvtType;
    private Text txtObjType;
    private Text txtInstanceType;
    private Text txtVersion;
    private Text txtProduct;
    private int noOfRows = 0;
    private RegisteredEvent[] eventReg = null;
    private EventEditor editor;
    private static final int TXT_LIMIT = 25;
    private static final String BLANK_STRING = "                                                                                                    ";

    public RegisterEventScreen() {
        super(null);
        this.createActions();
        this.addCoolBar(0x800000);
        this.addMenuBar();
        this.addStatusLine();
    }

    public RegisterEventScreen(EventEditor eventEditor) {
        super(null);
        this.editor = eventEditor;
        this.createActions();
        this.addCoolBar(0x800000);
        this.addMenuBar();
        this.addStatusLine();
    }

    public RegisteredEvent[] getEventReg() {
        return this.eventReg;
    }

    public void setEventReg(RegisteredEvent[] registeredEventArray) {
        this.eventReg = registeredEventArray;
    }

    public EventEditor getEditor() {
        return this.editor;
    }

    public void saveEventRegistryXML() {
        block2: {
            try {
                String string = this.editor.getEventRegistryLocation();
                File file = this.getEditor().findFileName(string);
                RegisteredEvent.saveEventRegistryXML(this.eventReg, file);
            }
            catch (Exception exception) {
                if (this.getShell() == null) break block2;
                MessageBox messageBox = new MessageBox(this.getShell(), 34);
                messageBox.setMessage("XML invalid");
                messageBox.setText("ALF Event Registry " + exception.getMessage());
                messageBox.open();
            }
        }
        this.refresh();
    }

    public Control createContents(Composite composite, RegisteredEvent[] registeredEventArray) {
        this.eventReg = registeredEventArray;
        Group group = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 6;
        gridLayout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)gridLayout);
        Button button = new Button((Composite)group, 0);
        button.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
            }
        });
        button.setLayoutData((Object)new GridData());
        button.setText("         &New Event           ");
        button.addSelectionListener((SelectionListener)new MySelectionAdapter(this){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Shell shell = ((Button)selectionEvent.getSource()).getParent().getParent().getParent().getShell();
                EditEventRegistration editEventRegistration = new EditEventRegistration(shell, 1);
                editEventRegistration.open(this.getPage(), -1);
            }
        });
        Label label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData(4, 2, true, true, 0, 0));
        label.setText("label                                   ");
        label.setVisible(false);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginHeight = 0;
        gridLayout2.numColumns = 8;
        gridLayout2.makeColumnsEqualWidth = false;
        gridLayout2.horizontalSpacing = 1;
        gridLayout2.verticalSpacing = 1;
        this.composite = new Group(composite, 20);
        this.composite.setLayout((Layout)gridLayout2);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 0));
        this.composite.setText("Registered Events");
        if (null != registeredEventArray && registeredEventArray.length > 0) {
            this.createRow((Composite)this.composite, registeredEventArray);
            this.composite.pack();
            this.composite.redraw();
            composite.update();
        } else {
            this.composite.setText("Registered Events");
            this.composite.setSize(800, 400);
            composite.pack();
            composite.redraw();
            this.composite.update();
            composite.update();
        }
        this.setContainer(composite);
        composite.update();
        return composite;
    }

    public void refresh() {
        this.noOfRows = 0;
        this.composite.dispose();
        this.getContainer().pack();
        this.getContainer().redraw();
        this.getContainer().update();
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 8;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.horizontalSpacing = 1;
        gridLayout.verticalSpacing = 1;
        this.composite = new Group(this.getContainer(), 20);
        this.composite.setLayout((Layout)gridLayout);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
        this.composite.setText("Registered Events");
        if (null != this.eventReg && this.eventReg.length > 0) {
            this.createRow((Composite)this.composite, this.eventReg);
            this.composite.pack();
            this.composite.redraw();
            this.getContainer().pack();
            this.getContainer().redraw();
        } else {
            this.composite.setSize(800, 400);
            this.getContainer().pack();
            this.getContainer().redraw();
            this.composite.update();
            this.getContainer().update();
        }
        this.composite.update();
        this.getContainer().update();
    }

    protected MenuManager createMenuManager() {
        MenuManager menuManager = new MenuManager("menu");
        return menuManager;
    }

    protected CoolBarManager createCoolBarManager(int n) {
        CoolBarManager coolBarManager = new CoolBarManager(n);
        return coolBarManager;
    }

    protected StatusLineManager createStatusLineManager() {
        StatusLineManager statusLineManager = new StatusLineManager();
        statusLineManager.setMessage(null, "");
        return statusLineManager;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("New Application");
    }

    private void createRow(final Composite composite, RegisteredEvent[] registeredEventArray) {
        Button button = new Button(composite, 2048);
        button.setLayoutData((Object)new GridData(4, 2, true, true, 0, 0));
        button.setText("          Edit          ");
        button.setVisible(false);
        Button button2 = new Button(composite, 0);
        button2.setLayoutData((Object)new GridData(4, 2, true, true, 0, 0));
        button2.setText("          Edit          ");
        button2.setVisible(false);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(2, 2, true, true, 0, 0));
        label.setText("Product                   ");
        Label label2 = new Label(composite, 0);
        label2.setLayoutData((Object)new GridData(2, 2, true, true, 0, 0));
        label2.setText("Product Version                  ");
        Label label3 = new Label(composite, 0);
        label3.setLayoutData((Object)new GridData(2, 2, true, true, 0, 0));
        label3.setText("Product Instance             ");
        Label label4 = new Label(composite, 0);
        label4.setLayoutData((Object)new GridData(2, 2, true, true, 0, 0));
        label4.setText("Object Type              ");
        Label label5 = new Label(composite, 0);
        label5.setLayoutData((Object)new GridData(2, 2, true, true, 0, 0));
        label5.setText("Event Type               ");
        Label label6 = new Label(composite, 0);
        label6.setLayoutData((Object)new GridData(2, 2, true, true, 0, 0));
        label6.setText("Event Match Name                ");
        for (int i = 0; i < registeredEventArray.length; ++i) {
            Button button3 = new Button(composite, 2048);
            button3.setLayoutData((Object)new GridData(4, 2, true, true, 0, 0));
            button3.setText("          Edit          ");
            button3.setData((Object)("" + this.noOfRows));
            button3.setBackground(Display.getCurrent().getSystemColor(1));
            button3.addSelectionListener((SelectionListener)new MySelectionAdapter(this){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    Button button = (Button)selectionEvent.getSource();
                    String string = button.getData().toString();
                    if (string != null) {
                        int n = 0;
                        try {
                            n = Integer.parseInt(string);
                            Button button2 = (Button)selectionEvent.getSource();
                            Shell shell = button2.getShell();
                            EditEventRegistration editEventRegistration = new EditEventRegistration(shell, 1);
                            editEventRegistration.open(this.getPage(), n);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
            Button button4 = new Button(composite, 2048);
            button4.setLayoutData((Object)new GridData(4, 2, true, true, 0, 0));
            button4.setText("         Delete         ");
            button4.setBackground(Display.getCurrent().getSystemColor(1));
            button4.setData((Object)("" + this.noOfRows));
            button4.addSelectionListener((SelectionListener)new MySelectionAdapter(this){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    Button button;
                    String string;
                    MessageBox messageBox = new MessageBox(composite.getShell(), 196);
                    messageBox.setMessage("Are you sure to delete the event ?");
                    messageBox.setText("Delete Event");
                    if (messageBox.open() == 64 && (string = (button = (Button)selectionEvent.getSource()).getData().toString()) != null) {
                        int n = 0;
                        try {
                            n = Integer.parseInt(string);
                            Object[] objectArray = this.getPage().getEventReg();
                            Object[] objectArray2 = ArrayManager.deleteAndAdjust(objectArray, n);
                            objectArray = new RegisteredEvent[objectArray2.length];
                            for (int i = 0; i < objectArray2.length; ++i) {
                                objectArray[i] = (RegisteredEvent)objectArray2[i];
                            }
                            this.getPage().setEventReg((RegisteredEvent[])objectArray);
                            this.getPage().saveEventRegistryXML();
                        }
                        catch (NumberFormatException numberFormatException) {
                            numberFormatException.printStackTrace();
                        }
                    }
                }
            });
            this.txtProduct = new Text(composite, 2120);
            this.txtProduct.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
            this.txtProduct.setTextLimit(25);
            this.txtProduct.setBackground(Display.getCurrent().getSystemColor(22));
            this.txtProduct.setTabs(8);
            String string = this.getSubString(registeredEventArray[i].getProduct());
            this.txtProduct.setText(string);
            this.txtProduct.setToolTipText(registeredEventArray[i].getProduct());
            this.txtVersion = new Text(composite, 2120);
            this.txtVersion.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
            this.txtVersion.setBackground(Display.getCurrent().getSystemColor(22));
            string = this.getSubString(registeredEventArray[i].getProductVersion());
            this.txtVersion.setText(string);
            this.txtVersion.setToolTipText(registeredEventArray[i].getProductVersion());
            this.txtInstanceType = new Text(composite, 2120);
            this.txtInstanceType.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
            this.txtInstanceType.setBackground(Display.getCurrent().getSystemColor(22));
            string = this.getSubString(registeredEventArray[i].getProductInstance());
            this.txtInstanceType.setText(string);
            this.txtInstanceType.setToolTipText(registeredEventArray[i].getProductInstance());
            this.txtObjType = new Text(composite, 2120);
            this.txtObjType.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
            this.txtObjType.setBackground(Display.getCurrent().getSystemColor(22));
            string = this.getSubString(registeredEventArray[i].getObjectType());
            this.txtObjType.setText(string);
            this.txtObjType.setToolTipText(registeredEventArray[i].getObjectType());
            this.txtEvtType = new Text(composite, 2120);
            this.txtEvtType.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
            this.txtEvtType.setBackground(Display.getCurrent().getSystemColor(22));
            string = this.getSubString(registeredEventArray[i].getEventType());
            this.txtEvtType.setText(string);
            this.txtEvtType.setToolTipText(registeredEventArray[i].getEventType());
            this.txtEvtMatch = new Text(composite, 2120);
            this.txtEvtMatch.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
            this.txtEvtMatch.setBackground(Display.getCurrent().getSystemColor(22));
            string = this.getSubString(registeredEventArray[i].getEventMatchName());
            this.txtEvtMatch.setText(string);
            this.txtEvtMatch.setToolTipText(registeredEventArray[i].getEventMatchName());
            ++this.noOfRows;
        }
    }

    private String getSubString(String string) {
        int n = 25 - string.length();
        String string2 = null;
        string2 = n > 0 ? (n > 16 ? string + BLANK_STRING.substring(0, n * 2) : string + BLANK_STRING.substring(0, (int)Math.abs((double)n * 2.25))) : string.substring(0, string.length() + n);
        return string2;
    }

    private void createActions() {
    }

    public Composite getContainer() {
        return this.container;
    }

    public void setContainer(Composite composite) {
        this.container = composite;
    }
}

