/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver.config.builder;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.builder.PKIConfigBuilder;
import org.eclipse.alf.security.sso.common.util.FileIOHelper;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvConfig;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvRPConfig;
import org.eclipse.alf.security.sso.server.federationserver.config.builder.FedSrvRPConfigBuilder;

public class FedSrvConfigBuilder {
    private static final Logger log = Logger.getLogger(FedSrvConfigBuilder.class);
    public static final String LOGONUI_CONFIG_LN = "LogonUIConfig";
    public static final String RPCONFIG_MAPPING_LN = "RPConfigMapping";
    public static final String PKI_CONFIG_LN = "PKIConfig";
    public static final String CORE_CONFIG_LN = "CoreConfig";
    public static final String FILE_ATTR_LN = "file";
    protected String basePath = null;

    public FedSrvConfigBuilder() {
    }

    public FedSrvConfigBuilder(String basePath) {
        this.basePath = basePath;
    }

    public String getLocalName() {
        return LOGONUI_CONFIG_LN;
    }

    public FedSrvConfig build(String basePath, String configFile) throws SSOException {
        return this.build(basePath, configFile, null);
    }

    public FedSrvConfig build(String basePath, String configFile, FedSrvConfig base) throws SSOException {
        this.basePath = basePath;
        return this.build(basePath + configFile, base);
    }

    public FedSrvConfig build(String configFile) throws SSOException {
        return this.build(configFile, (FedSrvConfig)null);
    }

    public FedSrvConfig build(String configFile, FedSrvConfig base) throws SSOException {
        InputStream is = FileIOHelper.loadResource((String)this.basePath, (String)configFile);
        if (is == null) {
            String errMsg = "Error loading configuration from \"" + configFile + "\": file not found";
            log.error((Object)errMsg);
            return null;
        }
        FedSrvConfig retval = this.build(is, base);
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                log.error((Object)"Failed to close input stream", (Throwable)e);
            }
        }
        return retval;
    }

    public FedSrvConfig build(InputStream instream) throws SSOException {
        return this.build(instream, null);
    }

    public FedSrvConfig build(InputStream instream, FedSrvConfig base) throws SSOException {
        if (instream == null) {
            log.error((Object)"Input stream is null!");
            return null;
        }
        StAXOMBuilder builder = null;
        OMElement el = null;
        try {
            builder = new StAXOMBuilder(instream);
            el = builder.getDocumentElement();
        }
        catch (XMLStreamException e) {
            String errMsg = "Error loading validation policy from stream";
            log.error((Object)errMsg);
            throw new SSOException(errMsg, (Throwable)e);
        }
        return this.build(el, base);
    }

    public FedSrvConfig build(OMElement element) throws SSOException {
        return this.build(element, null);
    }

    public FedSrvConfig build(OMElement element, FedSrvConfig base) throws SSOException {
        if (element == null) {
            log.warn((Object)"ServicesConfigBuilder.build(null) called");
            return null;
        }
        OMElement el = null;
        el = element.getLocalName().equals(this.getLocalName()) ? element : element.getFirstChildWithName(new QName(this.getLocalName()));
        if (el == null) {
            log.error((Object)"ServicesConfigBuilder.build(): services config element cannot be found");
            return null;
        }
        FedSrvConfig fedSrvConfig = null;
        fedSrvConfig = base != null ? base : new FedSrvConfig();
        FedSrvRPConfigBuilder rpConfigBuilder = new FedSrvRPConfigBuilder();
        rpConfigBuilder.setBasePath(this.basePath);
        OMElement pkiConfigEl = el.getFirstChildWithName(new QName(PKI_CONFIG_LN));
        if (pkiConfigEl != null) {
            PKIConfigBuilder pkiConfigBuilder = new PKIConfigBuilder();
            fedSrvConfig.setPKIConfig(pkiConfigBuilder.build(pkiConfigEl, fedSrvConfig.getPKIConfig()));
        } else {
            log.warn((Object)"<PKIConfig> element is missing. This relying party will not be able to sign messages");
        }
        Iterator it = el.getChildrenWithName(new QName(rpConfigBuilder.getLocalName()));
        int succeeded = 0;
        int failed = 0;
        if (it != null) {
            while (it.hasNext()) {
                OMElement next = (OMElement)it.next();
                FedSrvRPConfig rpConfig = rpConfigBuilder.build(next, null);
                if (rpConfig != null) {
                    fedSrvConfig.addRPConfig(rpConfig);
                    ++succeeded;
                    continue;
                }
                ++failed;
                log.error((Object)"Null service config returned from service config builder. Something went wrong");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Successfully loaded " + succeeded + " service configurations. Failed to load: " + failed));
        }
        return fedSrvConfig;
    }
}

