/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver.handler;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ExtendedResult;
import org.eclipse.alf.security.sso.common.RPURI;
import org.eclipse.alf.security.sso.common.token.SSOToken;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedData;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedDataObjectFactory;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedDataValidator;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.remotedata.RemoteDataClientImpl;
import org.eclipse.alf.security.sso.common.ws.message.trust.cancel.RSTCancelRequest;
import org.eclipse.alf.security.sso.common.ws.message.trust.issue.RSTIssueRequest;
import org.eclipse.alf.security.sso.common.ws.model.WSAbstractFactory;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SAML1Token;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SignedSecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrustVersion;
import org.eclipse.alf.security.sso.server.federationserver.PageRedirector;
import org.eclipse.alf.security.sso.server.federationserver.RequestContext;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvConfig;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvRPConfig;
import org.eclipse.alf.security.sso.server.federationserver.handler.MasterCookieHandler;

public class InboundWSFedHandler {
    private static final Logger log = Logger.getLogger(InboundWSFedHandler.class);

    public static boolean processRequest(HttpServletRequest req, HttpServletResponse resp, RequestContext requestContext) throws ServletException {
        WSFedData wsfData = WSFedHelper.getWSFDataFromRequestParameters((HttpServletRequest)req);
        if (wsfData == null) {
            String errorMessage = "Error creating extracting WS-Federation parameters from HTTP request";
            log.error((Object)errorMessage);
            PageRedirector.redirectAppError(req, resp, requestContext, "Malformed or invalid request data");
            return false;
        }
        if (wsfData.isEmpty()) {
            log.error((Object)"HTTP requests is missing WS-Federation PRP parameters");
            PageRedirector.redrectDirectFobidden(req, resp, requestContext);
            return false;
        }
        WSFedDataValidator wsfFedDataValidator = WSFedDataObjectFactory.createWSFedDataValidator();
        ExtendedResult wsfValidationResult = wsfFedDataValidator.validateRequest(wsfData);
        if (!wsfValidationResult.isSuccess()) {
            log.error((Object)("WS-Federation request profile validation failed: " + wsfValidationResult.getMessage()));
            PageRedirector.redirectAppError(req, resp, requestContext, "Invalid request");
            return false;
        }
        if (WSFedHelper.isRequestDataRemoted((WSFedData)wsfData) && !InboundWSFedHandler.retrieveRemoteData(req, resp, wsfData, requestContext)) {
            return false;
        }
        requestContext.setInboundWsfData(wsfData);
        if (StringHelper.isNotBlank((String)wsfData.getWtrealm())) {
            String rpuriString = wsfData.getWtrealm();
            RPURI rpuri = RPURI.createRPURI((String)rpuriString);
            if (rpuri == null) {
                log.error((Object)("Invalid federation request: applies to uri does not conform to ALF SSO format: \"" + rpuriString + "\""));
                PageRedirector.redirectAppError(req, resp, requestContext, "Invalid federation request: invalid relying party URI");
                return false;
            }
            requestContext.setAppliesToURI(rpuriString);
            FedSrvRPConfig rpConfig = FedSrvConfig.getInstance().getRPConfig(rpuriString);
            if (rpConfig == null) {
                log.error((Object)("Failed to find matching configuration for relying party request: \"" + rpuriString + "\""));
                PageRedirector.redirectAppError(req, resp, requestContext, "Failed to find matching configuration for relying party URI: \"" + rpuriString + "\"");
                return false;
            }
            requestContext.setRpConfig(rpConfig);
            if (StringHelper.isBlank((String)wsfData.getWreq())) {
                if (wsfData.isSigninAction()) {
                    long requestTokenTTL = requestContext.getRpConfig().getCoreConfig().getLongParameter("SecurityTokenTTL", 28800L);
                    RSTIssueRequest issueRequest = new RSTIssueRequest();
                    issueRequest.setAppliesTo(rpuriString);
                    issueRequest.setTtl(requestTokenTTL);
                    wsfData.setWreq(issueRequest.toOM().toString());
                } else {
                    if (wsfData.isSignoutAction()) {
                        MasterCookieHandler.queryMasterCookie(req, resp, requestContext);
                        if (requestContext.getMasterCookieData() != null && requestContext.getMasterCookieData().getToken() != null && !requestContext.getMasterCookieData().getToken().isExpired()) {
                            SSOToken cancelSSOTokenTarget = requestContext.getMasterCookieData().getToken();
                            SAML1Token cancelTarget = WSAbstractFactory.getWSSEObjectFactory().createSAML1Token(cancelSSOTokenTarget.getNativeObject());
                            RSTCancelRequest cancelReqest = new RSTCancelRequest();
                            cancelReqest.setSecurityToken((SignedSecurityToken)cancelTarget);
                            cancelReqest.setEpr(rpuriString);
                            requestContext.setWSTVersion(WSTrustVersion.V1);
                            requestContext.setRST(cancelReqest.toRequestSecurityToken());
                            requestContext.setRSTElement(cancelReqest.toRequestSecurityToken().toOM());
                            return true;
                        }
                        return true;
                    }
                    log.error((Object)("Unsupported WS-Federation action: \"" + wsfData.getWa() + "\""));
                    PageRedirector.redirectAppError(req, resp, requestContext, "Unsupported WS-Federation action: " + wsfData.getWa());
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean retrieveRemoteData(HttpServletRequest req, HttpServletResponse resp, WSFedData wsfData, RequestContext requestContext) throws ServletException {
        try {
            RemoteDataClientImpl remoteContentClient = new RemoteDataClientImpl();
            String remoteContentURL = wsfData.getWreqptr();
            String remoteContent = remoteContentClient.getRemoteContent(remoteContentURL, null);
            log.debug((Object)("remoteContentURL = " + remoteContentURL + " remoteContent" + remoteContent));
            if (remoteContent == null || remoteContent.trim().length() == 0) {
                log.error((Object)"Empty remote content returned");
                PageRedirector.redirectAppError(req, resp, requestContext, "Unable to get remote request data from " + wsfData.getWreqptr());
                return false;
            }
            wsfData.setWreq(remoteContent);
            wsfData.setWreqptr(null);
        }
        catch (Throwable e) {
            log.error((Object)"Retrieving remote data", e);
            PageRedirector.redirectAppError(req, resp, requestContext, "Error aquiring request data from " + wsfData.getWreqptr());
            return false;
        }
        return true;
    }
}

