/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http.configuration.builder;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.PKIConfigData;
import org.eclipse.alf.security.sso.common.http.configuration.builder.SecretElementBuilder;
import org.eclipse.alf.security.sso.common.util.StringHelper;

public class PKIConfigDataBuilder {
    private static final Logger log = Logger.getLogger(PKIConfigDataBuilder.class);
    public static final String SIGNATURE_CONFIG_DATA_LN = "SignatureConfig";
    public static final String ENCRYPTION_CONFIG_DATA_LN = "EncryptionConfig";
    public static final String KEYSTORE_ID_LN = "KeystoreId";
    public static final String PK_ALIAS_LN = "PKAlias";
    public static final String PK_PASSWORD_LN = "PKPassword";
    public static final String CERTIFICATE_INCLUSION_METHOD_LN = "CertificateInclusionMethod";

    public PKIConfigDataBuilder() {
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public PKIConfigData build(OMElement element, PKIConfigData base) {
        PKIConfigData retVal = new PKIConfigData();
        if (element == null) {
            return retVal;
        }
        if (base != null) {
            retVal = (PKIConfigData)base.clone();
        }
        OMElement keystoreIdEl = element.getFirstChildWithName(new QName(KEYSTORE_ID_LN));
        String keystoreId = null;
        if (keystoreIdEl != null) {
            keystoreId = keystoreIdEl.getText().trim();
        }
        OMElement certificateAliasEl = element.getFirstChildWithName(new QName(PK_ALIAS_LN));
        String alias = null;
        if (certificateAliasEl != null) {
            alias = certificateAliasEl.getText().trim();
        }
        OMElement certificatePasswordEl = element.getFirstChildWithName(new QName(PK_PASSWORD_LN));
        String certPassword = null;
        if (certificatePasswordEl != null) {
            SecretElementBuilder secretElementBuilder = new SecretElementBuilder();
            try {
                certPassword = secretElementBuilder.parse(certificatePasswordEl);
            }
            catch (SSOException e) {
                return null;
            }
        }
        OMElement certificateInclusionMethodEl = element.getFirstChildWithName(new QName(CERTIFICATE_INCLUSION_METHOD_LN));
        String certInclusionMethod = null;
        if (!(certificateInclusionMethodEl == null || (certInclusionMethod = certificateInclusionMethodEl.getText().trim()).equals("DirectReference") || certInclusionMethod.equals("IssuerSerial") || certInclusionMethod.equals("X509KeyIdentifier") || certInclusionMethod.equals("SKIKeyIdentifier") || certInclusionMethod.equals("EmbeddedKeyName") || certInclusionMethod.equals("Thumbprint"))) {
            certInclusionMethod = "DirectReference";
        }
        if (StringHelper.isNotBlank(keystoreId)) {
            retVal.setKeystoreId(keystoreId);
        }
        if (StringHelper.isNotBlank(alias)) {
            retVal.setCertAlias(alias);
        }
        if (StringHelper.isNotBlank(certPassword)) {
            retVal.setSigningCertPassword(certPassword);
        }
        if (StringHelper.isNotBlank(certInclusionMethod)) {
            retVal.setCertInclusionMethod(certInclusionMethod);
        }
        return retVal;
    }
}

