/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.policy.builder;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.token.saml.policy.BasePolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.TrustPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.builder.BasePolicyBuilder;
import org.eclipse.alf.security.sso.common.util.SSOHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.util.XMLHelper;

public class TrustPolicyBuilder
extends BasePolicyBuilder {
    private static final Logger log = Logger.getLogger(TrustPolicyBuilder.class);
    public static final String TRUST_POLICY_LN = "TrustPolicy";
    public static final String TRUSTED_ISSUERS_LN = "TrustedIssuers";
    public static final String TRUSTED_SUBJECTS_LN = "TrustedSubjects";
    public static final String ISSUER_URI_LN = "IssuerURI";
    public static final String SIGNATURE_CERTIFICATE_LN = "SignatureCertificateAlias";
    public static final String SUBJECT_NAME_LN = "SubjectName";
    public static final String SUBJECT_CERTIFICATE_LN = "SubjectCertificateAlias";
    public static final String ATTR_KEYSTORE_ID_LN = "keystoreName";

    public String getLocalName() {
        return TRUST_POLICY_LN;
    }

    public BasePolicy build(OMElement element) throws SSOException {
        return this.build(element, null);
    }

    public BasePolicy build(OMElement element, BasePolicy basePolicy) throws SSOException {
        OMElement next;
        if (element == null) {
            log.warn((Object)"TrustrPolicyBuilder.build(null) called");
            return basePolicy;
        }
        OMElement el = element.getFirstChildWithName(new QName(this.getLocalName()));
        if (el == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"TrustrPolicyBuilder.build(): policy local name not found");
            }
            return basePolicy;
        }
        TrustPolicy trustPolicy = null;
        trustPolicy = basePolicy != null ? (TrustPolicy)basePolicy.clone() : new TrustPolicy();
        if (SSOHelper.toBoolean(this.getAttribute(el, "override"), trustPolicy.getOverride())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"TrustPolicyBuilder.build(): Overriding previously defined policy");
            }
            trustPolicy = new TrustPolicy();
        }
        trustPolicy.setEnforced(SSOHelper.toBoolean(this.getAttribute(el, "enforce"), trustPolicy.getEnforced()));
        OMElement trustedIssuersEl = el.getFirstChildWithName(new QName(TRUSTED_ISSUERS_LN));
        if (trustedIssuersEl != null) {
            Iterator signatureCertIt;
            Iterator issuersIt = trustedIssuersEl.getChildrenWithName(new QName(ISSUER_URI_LN));
            if (issuersIt != null) {
                while (issuersIt.hasNext()) {
                    OMElement next2 = (OMElement)issuersIt.next();
                    String issuerURI = next2.getText().trim();
                    if (StringHelper.isBlank(issuerURI)) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)"Trust policy builder: Skipped empty <IssuerURI>");
                        continue;
                    }
                    trustPolicy.addTrustedIssuerURI(issuerURI);
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Trust policy builder: No trusted issuer URIs defined");
            }
            if ((signatureCertIt = trustedIssuersEl.getChildrenWithName(new QName(SIGNATURE_CERTIFICATE_LN))) != null) {
                while (signatureCertIt.hasNext()) {
                    next = (OMElement)signatureCertIt.next();
                    String certAlias = next.getText().trim();
                    String keystoreId = XMLHelper.getAttribute(next, ATTR_KEYSTORE_ID_LN);
                    if (StringHelper.isBlank(keystoreId)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Trust policy builder: assuming default keystore name default");
                        }
                        keystoreId = "default";
                    }
                    if (StringHelper.isBlank(certAlias)) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)"Trust policy builder: Skipped empty <SignatureCertificateAlias>");
                        continue;
                    }
                    TrustPolicy trustPolicy2 = trustPolicy;
                    trustPolicy2.getClass();
                    trustPolicy.addTrustedIssuerCertificateAlias(trustPolicy2.new TrustPolicy.CertAlias(certAlias, keystoreId));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Trust policy builder: No trusted issuer certificate aliases defined");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Trust policy builder: <TrustedIssuers> element is not defined");
        }
        OMElement trustedSubjectEl = el.getFirstChildWithName(new QName(TRUSTED_SUBJECTS_LN));
        if (trustedSubjectEl != null) {
            Iterator subjectCertIt;
            Iterator subjectsIt = trustedSubjectEl.getChildrenWithName(new QName(SUBJECT_NAME_LN));
            if (subjectsIt != null) {
                while (subjectsIt.hasNext()) {
                    next = (OMElement)subjectsIt.next();
                    String subjectName = next.getText().trim();
                    if (StringHelper.isBlank(subjectName)) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)"Trust policy builder: Skipped empty <SubjectName>");
                        continue;
                    }
                    trustPolicy.addTrustedSubjectName(subjectName);
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Trust policy builder: No trusted subject names defined");
            }
            if ((subjectCertIt = trustedIssuersEl.getChildrenWithName(new QName(SUBJECT_CERTIFICATE_LN))) != null) {
                while (subjectCertIt.hasNext()) {
                    OMElement next3 = (OMElement)subjectCertIt.next();
                    String certAlias = next3.getText().trim();
                    String keystoreId = XMLHelper.getAttribute(next3, ATTR_KEYSTORE_ID_LN);
                    if (StringHelper.isBlank(keystoreId)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Trust policy builder: assuming default keystore name default");
                        }
                        keystoreId = "default";
                    }
                    if (StringHelper.isBlank(certAlias)) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)"Trust policy builder: Skipped empty <SubjectCertificateAlias>");
                        continue;
                    }
                    TrustPolicy trustPolicy3 = trustPolicy;
                    trustPolicy3.getClass();
                    trustPolicy.addTrustedSubjectCertificateAlias(trustPolicy3.new TrustPolicy.CertAlias(certAlias, keystoreId));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Trust policy builder: No trusted subject certificate aliases defined");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Trust policy builder: <TrustedSubjects> element is not defined");
        }
        return trustPolicy;
    }
}

