/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.federation.passive.remotedata;

import java.io.IOException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.ws.federation.passive.remotedata.RemoteDataClient;

public class RemoteDataClientImpl
implements RemoteDataClient,
Cloneable {
    private static final Logger log = Logger.getLogger(RemoteDataClientImpl.class);

    public RemoteDataClientImpl() {
    }

    public RemoteDataClientImpl(RemoteDataClientImpl other) {
    }

    public String getRemoteContent(String urlString, CoreConfig config) throws SSOException {
        String response = null;
        GetMethod method = new GetMethod(urlString);
        HttpClient httpclient = new HttpClient();
        HttpState initialState = new HttpState();
        httpclient.getHttpConnectionManager().getParams().setConnectionTimeout(30000);
        httpclient.setState(initialState);
        try {
            method.getParams().setParameter("http.protocol.expect-continue", (Object)Boolean.TRUE);
            int status = httpclient.executeMethod((HttpMethod)method);
            if (status != 200) {
                log.error((Object)("method failed, response=" + HttpStatus.getStatusText((int)status)));
                String string = null;
                return string;
            }
            log.debug((Object)("method complete, response=" + method.getResponseBodyAsString()));
            byte[] respBuffer = method.getResponseBody();
            if (respBuffer != null) {
                response = new String(respBuffer, "UTF-8");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("WS-Federation Remote Data Access: get from remote returned=" + response));
                }
                String string = response;
                return string;
            }
        }
        catch (HttpException e) {
            log.error((Object)"Error aquiring remote data", (Throwable)e);
            throw new SSOException("Error aquiring remote data:" + e.getMessage(), e);
        }
        catch (SSLHandshakeException e) {
            log.error((Object)"Error aquiring remote data: SSL handshake failed", (Throwable)e);
            throw new SSOException("Error aquiring remote data", e);
        }
        catch (IOException e) {
            log.error((Object)"Error aquiring remote data", (Throwable)e);
            throw new SSOException("Error aquiring remote data", e);
        }
        finally {
            method.releaseConnection();
        }
        return response;
    }

    public Object clone() {
        return new RemoteDataClientImpl();
    }
}

