/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.message.soapengine.transport;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.TransportSender;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.transport.SSOLocalResponder;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.transport.SSOLocalTransportSender;

public class SSOLocalTransportReceiver {
    private static ThreadLocal CONFIG_CONTEXT = new ThreadLocal();
    private static ThreadLocal OPTIONS = new ThreadLocal();
    private ConfigurationContext confContext;
    private SSOLocalTransportSender sender;

    public SSOLocalTransportReceiver(ConfigurationContext configContext) {
        this.confContext = configContext;
    }

    public SSOLocalTransportReceiver(SSOLocalTransportSender sender) {
        this(SSOLocalTransportReceiver.getReceiverConfigurationContext());
        this.sender = sender;
    }

    public void processMessage(InputStream in, EndpointReference to) throws AxisFault {
        try {
            SOAPEnvelope realEnvelope;
            if (this.confContext == null) {
                throw new AxisFault("Missing configuration context");
            }
            AxisConfiguration config = this.confContext.getAxisConfiguration();
            TransportInDescription tIn = config.getTransportIn("local");
            TransportOutDescription tOut = config.getTransportOut("local");
            tOut.setSender((TransportSender)new SSOLocalResponder(this.sender));
            MessageContext msgCtx = new MessageContext();
            msgCtx.setConfigurationContext(this.confContext);
            msgCtx.setTransportIn(tIn);
            msgCtx.setTransportOut(tOut);
            msgCtx.setTo(to);
            msgCtx.setServerSide(true);
            msgCtx.setProperty("TRANSPORT_OUT", (Object)this.sender.getResponse());
            if (SSOLocalTransportReceiver.getOptions() != null) {
                msgCtx.setOptions(SSOLocalTransportReceiver.getOptions());
            }
            XMLStreamReader reader = StAXUtils.createXMLStreamReader((Reader)new BufferedReader(new InputStreamReader(in)));
            StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(reader, null);
            SOAPEnvelope envelope = (SOAPEnvelope)builder.getDocumentElement();
            OMElement realMessage = envelope.getBody().getFirstChildWithName(new QName("Envelope"));
            StAXSOAPModelBuilder realBuilder = new StAXSOAPModelBuilder(realMessage.getXMLStreamReader(), null);
            envelope = realEnvelope = (SOAPEnvelope)realBuilder.getDocumentElement();
            msgCtx.setEnvelope(envelope);
            AxisEngine engine = new AxisEngine(this.confContext);
            if (envelope.getBody().hasFault()) {
                engine.receiveFault(msgCtx);
            } else {
                engine.receive(msgCtx);
            }
        }
        catch (XMLStreamException e) {
            throw new AxisFault((Throwable)e);
        }
        catch (FactoryConfigurationError e) {
            throw new AxisFault((Throwable)e);
        }
    }

    public static ConfigurationContext getReceiverConfigurationContext() {
        return (ConfigurationContext)CONFIG_CONTEXT.get();
    }

    public static void setReceiverConfigurationContext(ConfigurationContext configurationContext) {
        CONFIG_CONTEXT.set(configurationContext);
    }

    public static Options getOptions() {
        return (Options)OPTIONS.get();
    }

    public static void setOptions(Options options) {
        OPTIONS.set(options);
    }
}

