/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;

public abstract class BaseWSObject
implements BaseWSInterface {
    protected List _anyAttr;
    protected List _anyElement;
    private OMElement parseSource;
    private boolean dirtyFlag;

    protected BaseWSObject() {
        this.reset();
    }

    public void reset() {
        this._anyAttr = new ArrayList();
        this._anyElement = new ArrayList();
        this.parseSource = null;
        this.dirtyFlag = false;
    }

    public void copyFrom(BaseWSInterface other) {
        if (!(other instanceof BaseWSObject)) {
            throw new IllegalArgumentException("Copy source must be compatible type");
        }
        BaseWSObject baseWSObject = (BaseWSObject)other;
        this._anyAttr = baseWSObject._anyAttr;
        this._anyElement = baseWSObject._anyElement;
        this.parseSource = baseWSObject.parseSource;
        this.dirtyFlag = baseWSObject.dirtyFlag;
    }

    protected OMElement getParseSource() {
        return this.parseSource;
    }

    protected void setParseSource(OMElement parseSource) {
        this.parseSource = parseSource;
        this.dirtyFlag = false;
    }

    protected boolean isParseSourceDirty() {
        if (this.parseSource == null) {
            return true;
        }
        return this.dirtyFlag;
    }

    public void setDirty() {
        this.dirtyFlag = true;
    }

    public void clearDirty() {
        this.dirtyFlag = false;
    }

    public List getAnyAttrList() {
        return this._anyAttr;
    }

    public List getAnyElementList() {
        return this._anyElement;
    }

    public String toString() {
        return this.toOM().toString();
    }

    public abstract boolean baseIsCompatibleElement(OMElement var1, String var2) throws SSOException;

    public boolean isCompatibleElement(OMElement element) throws SSOException {
        return this.baseIsCompatibleElement(element, this.getLocalName());
    }

    protected void addAnyAttributesToElement(OMElement element) {
        if (this._anyAttr.size() > 0) {
            for (Object current : this._anyAttr) {
                if (!(current instanceof OMAttribute)) continue;
                element.addAttribute((OMAttribute)current);
            }
        }
    }

    protected void addAnyElementsToElementAsChildren(OMElement element) {
        if (this._anyElement.size() > 0) {
            for (Object current : this._anyAttr) {
                if (current instanceof OMElement) {
                    element.addChild((OMNode)((OMElement)current));
                }
                if (!(current instanceof BaseWSInterface)) continue;
                element.addChild((OMNode)((BaseWSInterface)current).toOM());
            }
        }
    }
}

