/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common;

import java.util.ArrayList;
import java.util.List;

public abstract class ExtendedResult {
    protected int code = 0;
    protected String messageId = null;
    protected String message = null;
    protected List messageParams = null;

    public ExtendedResult() {
    }

    public ExtendedResult(int code, String msgid, String msg, Object[] msgparams) {
        this.code = code;
        this.messageId = msgid;
        this.message = msg;
        if (msgparams != null) {
            if (this.messageParams == null) {
                this.messageParams = new ArrayList();
            }
            this.setParamsFromArray(msgparams);
        }
    }

    public abstract boolean isSuccess();

    public int getCode() {
        return this.code;
    }

    public void setCode(int resultCode) {
        this.code = resultCode;
    }

    public String getMessage() {
        if (this.messageParams != null && this.messageParams.size() > 0) {
            return String.format(this.message, this.messageParams.toArray());
        }
        return this.message;
    }

    public void setMessage(String resultMessage) {
        this.message = resultMessage;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public Object[] getMessageParams() {
        if (this.messageParams != null) {
            return this.messageParams.toArray();
        }
        return null;
    }

    public void setMessageParams(Object[] messageParams) {
        this.messageParams = new ArrayList();
        this.setParamsFromArray(messageParams);
    }

    public void addMessageParam(Object param) {
        if (this.messageParams == null) {
            this.setMessageParams(new Object[]{param});
        } else {
            this.messageParams.add(param);
        }
    }

    protected void setParamsFromArray(Object[] messageParams) {
        if (messageParams != null) {
            for (int i = 0; i < messageParams.length; ++i) {
                this.messageParams.add(messageParams[i]);
            }
        }
    }
}

