/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.policy;

import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.token.SSOTokenPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.SAML1Policy;

public abstract class BasePolicy
implements SSOTokenPolicy,
Cloneable {
    private static final Logger log = Logger.getLogger(BasePolicy.class);
    private static final boolean DEFAULT_ENFORCED = true;
    private static final boolean DEFAULT_OVERRIDE = true;
    protected boolean enforced;
    protected boolean override;
    protected SAML1Policy contextPolicy;

    public BasePolicy() {
        if (log.isDebugEnabled()) {
            // empty if block
        }
        this.reset();
    }

    public BasePolicy(SAML1Policy contextPolicy) {
        this.reset();
        this.contextPolicy = contextPolicy;
    }

    public BasePolicy(BasePolicy other) {
        this.reset();
        this.enforced = other.enforced;
        this.override = other.override;
        this.contextPolicy = other.contextPolicy;
    }

    public void reset() {
        this.enforced = true;
        this.override = true;
        this.contextPolicy = null;
    }

    public boolean getEnforced() {
        return this.enforced;
    }

    public void setEnforced(boolean enforced) {
        this.enforced = enforced;
    }

    public boolean getOverride() {
        return this.override;
    }

    public void setOverride(boolean override) {
        this.override = override;
    }

    public SAML1Policy getContextPolicy() {
        return this.contextPolicy;
    }

    public void setContextPolicy(SAML1Policy contextPolicy) {
        this.contextPolicy = contextPolicy;
    }

    public abstract Object clone();
}

