/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.policy;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.token.saml.policy.BasePolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.SAML1Policy;

public class NameIdentifierPolicy
extends BasePolicy
implements Cloneable {
    private static final Logger log = Logger.getLogger(NameIdentifierPolicy.class);
    public static final boolean DEFAULT_ENFORCED = true;
    public static final boolean DEFAULT_MUST_INCLUDE = true;
    protected Map disallowedNameIdentifierFormats;
    protected boolean mustInclude;

    public NameIdentifierPolicy() {
    }

    public NameIdentifierPolicy(NameIdentifierPolicy other) {
        super(other);
        if (other.disallowedNameIdentifierFormats != null) {
            Iterator it = other.disallowedNameIdentifierFormats.entrySet().iterator();
            if (it != null) {
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    String key = (String)entry.getKey();
                    Set value = (Set)entry.getValue();
                    HashSet<String> newvalue = new HashSet<String>();
                    Iterator it2 = value.iterator();
                    while (it2 != null && it2.hasNext()) {
                        String s = (String)it2.next();
                        newvalue.add(s);
                    }
                    this.disallowedNameIdentifierFormats.put(key, newvalue);
                }
            }
        } else {
            this.disallowedNameIdentifierFormats = null;
        }
        this.mustInclude = other.mustInclude;
    }

    public NameIdentifierPolicy(SAML1Policy contextPolicy) {
        super(contextPolicy);
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public void reset() {
        this.disallowedNameIdentifierFormats = new HashMap();
        this.mustInclude = true;
    }

    public static boolean getIsEnforcedByDefault() {
        return true;
    }

    public Map getDisallowedNameIdentifierFormats() {
        return this.disallowedNameIdentifierFormats;
    }

    public Set getDisallowedNameIdentifierFormats(String nameQualifier) {
        return (Set)this.disallowedNameIdentifierFormats.get(nameQualifier);
    }

    public void setDisallowedNameIdentifierFormats(Map disallowedNameIdentifierFormats) {
        this.disallowedNameIdentifierFormats = disallowedNameIdentifierFormats;
    }

    public void addDisallowedNameIdentifier(String nameQualifier, Set disallowedNameIdentifierFormatsSet) {
        this.disallowedNameIdentifierFormats.put(nameQualifier, disallowedNameIdentifierFormatsSet);
    }

    public boolean getMustInclude() {
        return this.mustInclude;
    }

    public void setMustInclude(boolean mustInclude) {
        this.mustInclude = mustInclude;
    }

    public Object clone() {
        return new NameIdentifierPolicy(this);
    }
}

