/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.message.trust.issue;

import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ws.message.trust.RSTRequest;
import org.eclipse.alf.security.sso.common.ws.model.WSAbstractFactory;
import org.eclipse.alf.security.sso.common.ws.model.addressing.WSAddressingObjectFactory;
import org.eclipse.alf.security.sso.common.ws.model.addressing.element.Address;
import org.eclipse.alf.security.sso.common.ws.model.addressing.element.EndpointReference;
import org.eclipse.alf.security.sso.common.ws.model.policy.WSPolicyObjectFactory;
import org.eclipse.alf.security.sso.common.ws.model.policy.element.AppliesTo;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrust;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrustObjectFactory;
import org.eclipse.alf.security.sso.common.ws.model.trust.custom.alf.WSTrustAlfClaimsObjectFactory;
import org.eclipse.alf.security.sso.common.ws.model.trust.custom.alf.element.Claim;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.Claims;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.Lifetime;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.OnBehalfOf;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestSecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestType;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.TokenType;

public class RSTIssueRequest
extends RSTRequest {
    private static final Logger log = Logger.getLogger(RSTIssueRequest.class);
    protected String appliesTo = null;
    protected SecurityToken onBehalfOfSecurityToken = null;
    protected String ssoTokenType = null;
    protected long ttl = 300L;

    public RSTIssueRequest() {
    }

    public RSTIssueRequest(WSTrust wst) {
        super(wst);
    }

    public OMElement toOM() {
        if (this.rawRSTElement != null) {
            return this.rawRSTElement;
        }
        WSTrust wst = new WSTrust();
        WSTrustObjectFactory wstfac = WSAbstractFactory.getWSTObjectFactory();
        WSPolicyObjectFactory wspfac = WSAbstractFactory.getWSPObjectFactory();
        WSAddressingObjectFactory wsafac = WSAbstractFactory.getWSAObjectFactory();
        WSTrustAlfClaimsObjectFactory alffac = WSAbstractFactory.getWSTrustAlfClaimsObjectFactory();
        RequestSecurityToken rst = wstfac.createRequestSecurityToken();
        RequestType requestType = wstfac.createRequestType(wst.RequestTypes.getIssue());
        TokenType tokenType = wstfac.createTokenType("urn:oasis:names:tc:SAML:1.0:assertion#Assertion");
        long now = System.currentTimeMillis();
        long maxSecs = 9223372036854775L;
        if (this.ttl >= maxSecs) {
            this.ttl = maxSecs;
        }
        Lifetime lifetime = wstfac.createLifetime(now, now + this.ttl * 1000L);
        Address address = wsafac.createAddress(this.appliesTo);
        EndpointReference epr = wsafac.createEndpointReference();
        epr.setAddress(address);
        AppliesTo appliesTo = wspfac.createAppliesTo();
        appliesTo.addChildObject(epr);
        OnBehalfOf onBehalfOf = null;
        if (this.onBehalfOfSecurityToken != null) {
            onBehalfOf = wstfac.createOnBehalfOf();
            onBehalfOf.setSecurityToken(this.onBehalfOfSecurityToken);
        }
        Claims claims = null;
        if (this.ssoTokenType != null) {
            claims = wstfac.createClaims();
            claims.setDialectAttribute("http://www.eclipse.org/ALF/1.0/claims");
            Claim claim = alffac.createClaim("http://www.eclipse.org/ALF/1.0/claims/TicketType", this.ssoTokenType);
            claims.addClaim(claim);
        }
        rst.setRequestType(requestType);
        rst.setTokenType(tokenType);
        rst.setLifetime(lifetime);
        rst.setAppliesTo(appliesTo);
        rst.setOnBehalfOf(onBehalfOf);
        rst.setClaims(claims);
        OMElement rstEl = rst.toOM();
        return rstEl;
    }

    public String getAction() {
        if (this.action == null) {
            return this.wst.Actions.getRequestSecurityTokenIssue();
        }
        return this.action;
    }

    public String getAppliesTo() {
        return this.appliesTo;
    }

    public void setAppliesTo(String appliesTo) {
        this.appliesTo = appliesTo;
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public void setOnBehalfOfSecurityToken(SecurityToken onBehalfOfSecurityToken) {
        this.onBehalfOfSecurityToken = onBehalfOfSecurityToken;
    }

    public SecurityToken getOnBehalfOfSecurityToken() {
        return this.onBehalfOfSecurityToken;
    }

    public void setSSOTokenType(String ssoTokenType) {
        this.ssoTokenType = ssoTokenType;
    }

    public String getSSOTokenType(String ssoTokenType) {
        return ssoTokenType;
    }
}

