/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.trust.custom.alf.element.impl;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.trust.custom.alf.WSTrustAlfClaims;
import org.eclipse.alf.security.sso.common.ws.model.trust.custom.alf.element.Claim;
import org.eclipse.alf.security.sso.common.ws.model.trust.custom.alf.element.impl.BaseWSTrustAlfClaimsObjectImpl;

public class ClaimImpl
extends BaseWSTrustAlfClaimsObjectImpl
implements Claim {
    private static final Logger log = Logger.getLogger(ClaimImpl.class);
    protected String claimTypeAttribute;
    protected String claimValue;

    public ClaimImpl() {
        this.reset();
    }

    public ClaimImpl(String claimType) {
        this.reset();
        this.claimTypeAttribute = claimType;
    }

    public ClaimImpl(String claimType, String claimValue) {
        this.reset();
        this.claimTypeAttribute = claimType;
        this.claimValue = claimValue;
    }

    public String getLocalName() {
        return "Claim";
    }

    public void reset() {
        super.reset();
        this.claimTypeAttribute = null;
        this.claimValue = null;
    }

    public void copyFrom(BaseWSInterface other) {
        super.copyFrom(other);
        if (other instanceof ClaimImpl) {
            ClaimImpl otherClaimImpl = (ClaimImpl)other;
            this.claimTypeAttribute = otherClaimImpl.claimTypeAttribute;
            this.claimValue = otherClaimImpl.claimValue;
        }
    }

    public void setClaimTypeAttribute(String claimTypeAttribute) {
        this.claimTypeAttribute = claimTypeAttribute;
        this.setDirty();
    }

    public String getClaimTypeAttribute() {
        return this.claimTypeAttribute;
    }

    public void setClaimValue(String claimValue) {
        this.claimValue = claimValue;
        this.setDirty();
    }

    public String getClaimValue() {
        return this.claimValue;
    }

    public OMElement toOM() {
        return this.toOM(null);
    }

    public OMElement toOM(OMElement parent) {
        if (!this.isParseSourceDirty()) {
            if (parent != null) {
                parent.addChild((OMNode)this.getParseSource());
            }
            return this.getParseSource();
        }
        OMElement claimEl = WSTrustAlfClaims.createOMElement(parent, this.getLocalName());
        OMAttribute attrClaimType = null;
        if (this.claimTypeAttribute != null) {
            OMNamespace wsalfns = WSTrustAlfClaims.getOMNamespace();
            attrClaimType = OMAbstractFactory.getOMFactory().createOMAttribute("ClaimType", wsalfns, this.claimTypeAttribute);
            claimEl.addAttribute(attrClaimType);
        }
        if (this.claimValue != null) {
            claimEl.setText(this.claimValue);
        }
        this.addAnyAttributesToElement(claimEl);
        this.addAnyElementsToElementAsChildren(claimEl);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created " + this.getLocalName() + " object:[" + claimEl.toString() + "]"));
        }
        return claimEl;
    }

    public BaseWSInterface fromOM(OMElement element) throws SSOException {
        if (!this.isCompatibleElement(element)) {
            return null;
        }
        ClaimImpl claim = new ClaimImpl();
        OMAttribute attr = element.getAttribute(new QName("http://www.eclipse.org/ALF/1.0/claims", "ClaimType"));
        if (attr != null) {
            claim.setClaimTypeAttribute(attr.getAttributeValue());
        }
        claim.setClaimValue(element.getText());
        claim.setParseSource(element);
        this.copyFrom(claim);
        return this;
    }
}

