/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.trust.element.impl;

import java.util.Iterator;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.GenericAttribute;
import org.eclipse.alf.security.sso.common.ws.model.addressing.WSAddressingObjectBuilder;
import org.eclipse.alf.security.sso.common.ws.model.addressing.element.EndpointReference;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.WSSecExtObjectBuilder;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.SecurityTokenReference;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.impl.SAML1TokenImpl;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.impl.UsernameTokenImpl;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrust;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.OnBehalfOf;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.BaseWSTrustObjectImpl;

public class OnBehalfOfImpl
extends BaseWSTrustObjectImpl
implements OnBehalfOf {
    private static final Logger log = Logger.getLogger(OnBehalfOfImpl.class);
    protected WSTrust wst;
    protected SecurityToken securityToken;
    protected SecurityTokenReference securityTokenReference;
    protected EndpointReference endpointReference;

    public OnBehalfOfImpl() {
        this.reset();
        this.wst = new WSTrust();
    }

    public OnBehalfOfImpl(WSTrust wst) {
        this.reset();
        this.wst = wst;
    }

    public String getLocalName() {
        return "OnBehalfOf";
    }

    public void reset() {
        super.reset();
        this.endpointReference = null;
        this.securityToken = null;
        this.securityTokenReference = null;
    }

    public void copyFrom(BaseWSInterface other) {
        super.copyFrom(other);
        if (other instanceof OnBehalfOfImpl) {
            OnBehalfOfImpl otherOnBehalfOfImpl = (OnBehalfOfImpl)other;
            this.wst = otherOnBehalfOfImpl.wst;
            this.endpointReference = otherOnBehalfOfImpl.endpointReference;
            this.securityToken = otherOnBehalfOfImpl.securityToken;
            this.securityTokenReference = otherOnBehalfOfImpl.securityTokenReference;
        }
    }

    public SecurityToken getSecurityToken() {
        return this.securityToken;
    }

    public void setSecurityToken(SecurityToken securityToken) {
        this.securityToken = securityToken;
        this.endpointReference = null;
        this.securityTokenReference = null;
        this.setDirty();
    }

    public SecurityTokenReference getSecurityTokenReference() {
        return this.securityTokenReference;
    }

    public void setSecurityTokenReference(SecurityTokenReference securityTokenReference) {
        this.securityTokenReference = securityTokenReference;
        this.securityToken = null;
        this.endpointReference = null;
        this.setDirty();
    }

    public EndpointReference getEndpointReference() {
        return this.endpointReference;
    }

    public void setEndpointReference(EndpointReference endpointReference) {
        this.endpointReference = endpointReference;
        this.securityToken = null;
        this.securityTokenReference = null;
        this.setDirty();
    }

    public OMElement toOM() {
        return this.toOM(null);
    }

    public OMElement toOM(OMElement parent) {
        if (!this.isParseSourceDirty()) {
            if (parent != null) {
                parent.addChild((OMNode)this.getParseSource());
            }
            return this.getParseSource();
        }
        OMElement onBehalfOfEl = this.wst.createOMElement(parent, this.getLocalName());
        if (this.securityToken != null) {
            this.securityToken.toOM(onBehalfOfEl);
        }
        if (this.securityTokenReference != null) {
            this.securityTokenReference.toOM(onBehalfOfEl);
        }
        if (this.endpointReference != null) {
            this.endpointReference.toOM(onBehalfOfEl);
        }
        this.addAnyAttributesToElement(onBehalfOfEl);
        this.addAnyElementsToElementAsChildren(onBehalfOfEl);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created " + this.getLocalName() + " object:[" + onBehalfOfEl.toString() + "]"));
        }
        return onBehalfOfEl;
    }

    public boolean isCompatibleElement(OMElement element) throws SSOException {
        return this.baseIsCompatibleElementTrust(element, this.getLocalName()) != null;
    }

    public BaseWSInterface fromOM(OMElement element) throws SSOException {
        WSTrust wst = this.baseIsCompatibleElementTrust(element, this.getLocalName());
        if (wst == null) {
            return null;
        }
        log.debug((Object)"Parsing <wst:OnBehalfOf> element");
        OnBehalfOfImpl onBehalfOf = new OnBehalfOfImpl(wst);
        Iterator it = element.getAllAttributes();
        if (it != null) {
            while (it.hasNext()) {
                OMAttribute attr = (OMAttribute)it.next();
                onBehalfOf._anyAttr.add(new GenericAttribute(attr.getLocalName(), attr.getAttributeValue()));
            }
        }
        if ((it = element.getChildElements()) != null) {
            while (it.hasNext()) {
                OMElement workEl = (OMElement)it.next();
                String localName = workEl.getLocalName();
                if ("SecurityTokenReference".equals(localName)) {
                    onBehalfOf.securityTokenReference = WSSecExtObjectBuilder.buildSecurityTokenReference(workEl);
                    continue;
                }
                if ("EndpointReference".equals(localName)) {
                    onBehalfOf.endpointReference = WSAddressingObjectBuilder.buildEndpointReference(workEl);
                    continue;
                }
                if (new UsernameTokenImpl().isCompatibleElement(workEl)) {
                    onBehalfOf.securityToken = WSSecExtObjectBuilder.buildSecurityToken(workEl);
                    continue;
                }
                if (new SAML1TokenImpl().isCompatibleElement(workEl)) {
                    onBehalfOf.securityToken = WSSecExtObjectBuilder.buildSecurityToken(workEl);
                    continue;
                }
                onBehalfOf._anyElement.add(workEl.cloneOMElement());
            }
        }
        onBehalfOf.setParseSource(element);
        this.copyFrom(onBehalfOf);
        return this;
    }

    public WSTrust getWSTrust() {
        return this.wst;
    }
}

