/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.crypto.impl;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.crypto.CryptoProvider;
import org.eclipse.alf.security.sso.common.util.SSOHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;

public class ALFSSOCryptoProvider
implements CryptoProvider,
Cloneable {
    static final Logger log = Logger.getLogger(ALFSSOCryptoProvider.class);
    public static final String DEFAULT_JCE_PROVIDER_ID = "BC";
    public static final String DEFAULT_JCE_PROVIDER_CLASS = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    public static final int DEFAULT_KEY_SIZE = 128;
    protected boolean initialized = false;
    protected String cryptoAlgorithm = null;
    protected String cryptoPassword = null;
    protected String jceProviderId = null;
    protected String jceProviderClass = null;
    protected int keySize = 0;
    protected Cipher encryptingCipher = null;
    protected Cipher decryptingCipher = null;
    protected SecretKey cipherKey = null;
    protected boolean cryptoEnabled = false;
    protected Provider jceProvider = null;

    protected ALFSSOCryptoProvider() {
    }

    public ALFSSOCryptoProvider(ALFSSOCryptoProvider other) {
        this.cryptoAlgorithm = other.cryptoAlgorithm;
        this.cryptoPassword = other.cryptoPassword;
        this.jceProviderId = other.jceProviderId;
        this.jceProviderClass = other.jceProviderClass;
        this.keySize = other.keySize;
        this.encryptingCipher = other.encryptingCipher;
        this.decryptingCipher = other.decryptingCipher;
        this.cryptoEnabled = other.cryptoEnabled;
        this.jceProvider = other.jceProvider;
    }

    public ALFSSOCryptoProvider(String cryptoAlgorithm, String cryptoPassword, String jceProviderId, String jceProviderClass, int keySize) throws SSOException {
        this.cryptoAlgorithm = cryptoAlgorithm;
        this.cryptoPassword = cryptoPassword;
        this.jceProviderId = jceProviderId;
        this.jceProviderClass = jceProviderClass;
        this.keySize = keySize;
        this.initialized = false;
    }

    protected void initialize() throws SSOException {
        if (StringHelper.isBlank(this.cryptoAlgorithm)) {
            this.cryptoEnabled = false;
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (StringHelper.isNotBlank(this.jceProviderId) && StringHelper.isNotBlank(this.jceProviderClass)) {
            this.jceProvider = SSOHelper.loadJCEProvider(cl, this.jceProviderId, this.jceProviderClass);
            if (this.jceProvider == null) {
                throw new SSOException("Failed to create JCE provider: " + this.jceProviderId + ":" + this.jceProviderClass);
            }
            try {
                Class[] getInstanceParams = new Class[]{String.class, Provider.class};
                Cipher.class.getMethod("getInstance", getInstanceParams);
            }
            catch (NoSuchMethodException e) {
                if (SSOHelper.loadAndRegisterJCEProvider(cl, this.jceProviderId, this.jceProviderClass, 2) == null) {
                    throw new SSOException("Failed to create JCE provider: " + this.jceProviderId + ":" + this.jceProviderClass);
                }
                this.jceProvider = null;
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Skipped initializtion of JCE provider due to lack of provider creation parameters (id, class)");
        }
        this.encryptingCipher = this.createCipher(this.cryptoAlgorithm);
        this.decryptingCipher = this.createCipher(this.cryptoAlgorithm);
        this.cipherKey = null;
        if (StringHelper.isBlank(this.cryptoPassword)) {
            int maxKeySize = 0;
            try {
                maxKeySize = Cipher.getMaxAllowedKeyLength(this.cryptoAlgorithm);
            }
            catch (NoSuchAlgorithmException e) {
                String errorMsg = "Failed to determine maximum key size for transformation \"" + this.cryptoAlgorithm + "\" : no such algorithm";
                log.error((Object)errorMsg, (Throwable)e);
                throw new SSOException(errorMsg);
            }
            if (this.keySize == Integer.MAX_VALUE || this.keySize > maxKeySize) {
                this.keySize = maxKeySize;
            }
            this.cipherKey = this.generateKey(this.cryptoAlgorithm, this.keySize);
        } else {
            this.cipherKey = this.generateKey(this.cryptoAlgorithm, this.cryptoPassword);
        }
        try {
            this.encryptingCipher.init(1, this.cipherKey);
            this.decryptingCipher.init(2, this.cipherKey);
        }
        catch (InvalidKeyException e) {
            String errorMsg = "Faled to initialize cypher: Invalid key";
            log.error((Object)errorMsg, (Throwable)e);
            throw new SSOException(errorMsg, e);
        }
        this.cryptoEnabled = true;
        this.initialized = true;
    }

    protected Cipher createCipher(String cryptoAlgorithm) throws SSOException {
        if (StringHelper.isBlank(cryptoAlgorithm)) {
            throw new IllegalArgumentException("Crypto algorithm cannot be null or empty");
        }
        Cipher cipher = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ALF SSO Crypto Provider: creating cipher for \"" + cryptoAlgorithm + "\""));
            }
            if (this.jceProvider != null) {
                try {
                    cipher = Cipher.getInstance(cryptoAlgorithm, this.jceProvider);
                }
                catch (NoSuchMethodError e) {
                    log.error((Object)"Incompatible provider: provider must implement Java 1.4.x JCE classes");
                }
            }
            if (cipher == null && StringHelper.isNotBlank(this.jceProviderId)) {
                cipher = Cipher.getInstance(cryptoAlgorithm, this.jceProviderId);
            }
            if (cipher == null && StringHelper.isBlank(this.jceProviderId)) {
                cipher = Cipher.getInstance(cryptoAlgorithm);
            }
            if (cipher == null) {
                String errorMessage = "Failed to created cipher object";
                log.error((Object)errorMessage);
                throw new SSOException(errorMessage);
            }
        }
        catch (NoSuchAlgorithmException e) {
            String errorMsg = "Failed to create cipher: No such algorithm: \"" + cryptoAlgorithm + "\" : " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new SSOException(errorMsg, e);
        }
        catch (NoSuchPaddingException e) {
            String errorMsg = "Failed to create cipher: No such padding: " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new SSOException(errorMsg, e);
        }
        catch (NoSuchProviderException e) {
            String errorMsg = "Failed to create cipher: No such provider: \"" + this.jceProviderId + "\" : " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new SSOException(errorMsg, e);
        }
        catch (Throwable e) {
            String errorMsg = "Failed to create cipher: " + e.getMessage();
            log.error((Object)errorMsg, e);
            throw new SSOException(errorMsg, e);
        }
        return cipher;
    }

    protected SecretKey generateKey(String cryptoAlgorithm, int maxKeySize) throws SSOException {
        if (StringHelper.isBlank(cryptoAlgorithm)) {
            throw new IllegalArgumentException("Crypto algorithm cannot be null or empty");
        }
        KeyGenerator keyGenerator = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ALF SSO Crypto Provider: generating random secret for \"" + cryptoAlgorithm + "\""));
            }
            if (this.jceProvider != null) {
                try {
                    keyGenerator = KeyGenerator.getInstance(cryptoAlgorithm, this.jceProvider);
                }
                catch (NoSuchMethodError e) {
                    log.error((Object)"Incompatible provider: provider must implement Java 1.4.x JCE classes");
                }
            }
            if (keyGenerator == null && StringHelper.isNotBlank(this.jceProviderId)) {
                keyGenerator = KeyGenerator.getInstance(cryptoAlgorithm, this.jceProviderId);
            }
            if (keyGenerator == null && StringHelper.isBlank(this.jceProviderId)) {
                keyGenerator = KeyGenerator.getInstance(cryptoAlgorithm);
            }
            if (keyGenerator == null) {
                String errorMessage = "Failed to created KeyGenerator object";
                log.error((Object)errorMessage);
                throw new SSOException(errorMessage);
            }
            keyGenerator.init(maxKeySize);
            return keyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            String errorMsg = "Failed to generate key: No such algorithm: \"" + cryptoAlgorithm + "\" : " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new SSOException(errorMsg, e);
        }
        catch (NoSuchProviderException e) {
            String errorMsg = "Failed to generate key: No such provider: \"" + this.jceProviderId + "\" : " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new SSOException(errorMsg, e);
        }
        catch (Throwable e) {
            String errorMsg = "Failed to generate key: " + e.getMessage();
            log.error((Object)errorMsg, e);
            throw new SSOException(errorMsg, e);
        }
    }

    protected SecretKey generateKey(String cryptoAlgorithm, String password) throws SSOException {
        if (StringHelper.isBlank(cryptoAlgorithm)) {
            throw new IllegalArgumentException("Crypto algorithm cannot be null or empty");
        }
        SecretKeyFactory fac = null;
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password.toCharArray());
        try {
            fac = SecretKeyFactory.getInstance(cryptoAlgorithm, this.jceProvider);
            if (log.isDebugEnabled()) {
                log.debug((Object)("ALF SSO Crypto Provider: generating secret from password for \"" + cryptoAlgorithm + "\""));
            }
            if (this.jceProvider != null) {
                try {
                    fac = SecretKeyFactory.getInstance(cryptoAlgorithm, this.jceProvider);
                }
                catch (NoSuchMethodError e) {
                    log.error((Object)"Incompatible provider: provider must implement Java 1.4.x JCE classes");
                }
            }
            if (fac == null && StringHelper.isNotBlank(this.jceProviderId)) {
                fac = SecretKeyFactory.getInstance(cryptoAlgorithm, this.jceProviderId);
            }
            if (fac == null && StringHelper.isBlank(this.jceProviderId)) {
                fac = SecretKeyFactory.getInstance(cryptoAlgorithm);
            }
            if (fac == null) {
                String errorMessage = "Failed to created SecretKeyFactory object";
                log.error((Object)errorMessage);
                throw new SSOException(errorMessage);
            }
            return fac.generateSecret(pbeKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            String errorMsg = "Failed to generate key: No such algorithm: \"" + cryptoAlgorithm + "\" : " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new SSOException(errorMsg, e);
        }
        catch (NoSuchProviderException e) {
            String errorMsg = "Failed to generate key: No such provider: \"" + this.jceProviderId + "\" : " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new SSOException(errorMsg, e);
        }
        catch (InvalidKeySpecException e) {
            String errorMsg = "Failed to generate key: Invalid key spec";
            log.error((Object)errorMsg, (Throwable)e);
            throw new SSOException(errorMsg, e);
        }
    }

    public byte[] encrypt(byte[] content) throws SSOException {
        if (content == null) {
            return null;
        }
        if (!this.initialized) {
            this.initialize();
        }
        if (!this.cryptoEnabled) {
            return content;
        }
        byte[] encryptedContent = null;
        try {
            encryptedContent = this.encryptingCipher.doFinal(content);
        }
        catch (BadPaddingException e) {
            String errorMsg = "Error during encryption: bad padding";
            log.debug((Object)errorMsg, (Throwable)e);
            throw new SSOException(errorMsg, e);
        }
        catch (IllegalBlockSizeException e) {
            String errorMsg = "Error during encryption: illegal block size";
            log.debug((Object)errorMsg, (Throwable)e);
            throw new SSOException(errorMsg, e);
        }
        return encryptedContent;
    }

    public byte[] decrypt(byte[] content) throws SSOException {
        if (content == null) {
            return null;
        }
        if (!this.initialized) {
            this.initialize();
        }
        if (!this.cryptoEnabled) {
            return content;
        }
        byte[] decryptedContent = null;
        try {
            decryptedContent = this.decryptingCipher.doFinal(content);
        }
        catch (BadPaddingException e) {
            String errorMsg = "Error during decryption: bad padding";
            log.debug((Object)errorMsg, (Throwable)e);
            return null;
        }
        catch (IllegalBlockSizeException e) {
            String errorMsg = "Error during decryption: illegal block size";
            log.error((Object)errorMsg, (Throwable)e);
            return null;
        }
        return decryptedContent;
    }

    public Object clone() {
        return new ALFSSOCryptoProvider(this);
    }
}

