/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http.configuration.matcher;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.AbstractMatcher;
import org.eclipse.alf.security.sso.common.util.StringHelper;

public class SimpleStringMatcher
extends AbstractMatcher {
    private static final Logger log = Logger.getLogger(SimpleStringMatcher.class);
    public static final String DEFAULT_REGEX_STRING = "*";
    public static final String DEFAULT_REGEX_STRING_JAVAREGEX = ".*";
    protected String regexString;
    protected Pattern regexPattern;

    public SimpleStringMatcher() {
        this.reset();
    }

    public SimpleStringMatcher(int matcherType) {
        super(matcherType);
        this.reset();
    }

    public SimpleStringMatcher(int matcherType, String regexString) throws SSOException {
        super(matcherType);
        this.reset();
        this.regexString = regexString;
        if (matcherType == 2) {
            try {
                this.regexPattern = Pattern.compile(regexString);
            }
            catch (PatternSyntaxException e) {
                String errorMessage = "Invalid regex pattern: \"" + regexString + "\"";
                log.error((Object)errorMessage);
                throw new SSOException(errorMessage, e);
            }
        }
    }

    public void reset() {
        if (this.matcherType == 2) {
            this.regexString = DEFAULT_REGEX_STRING_JAVAREGEX;
            try {
                this.regexPattern = Pattern.compile(this.regexString);
            }
            catch (PatternSyntaxException patternSyntaxException) {}
        } else if (this.matcherType == 1) {
            this.regexString = DEFAULT_REGEX_STRING;
        } else {
            throw new RuntimeException("Invalid matcher type:" + this.matcherType);
        }
    }

    public boolean isMatchAllMatcher() {
        String defaultPattern = this.matcherType == 2 ? DEFAULT_REGEX_STRING_JAVAREGEX : DEFAULT_REGEX_STRING;
        return this.regexString.equals(defaultPattern);
    }

    public boolean matches(String matchString) {
        if (this.matcherType == 2) {
            this.matchScore = null;
            Matcher matcher = this.regexPattern.matcher(matchString);
            return matcher != null && matcher.matches();
        }
        if (this.matcherType == 1) {
            int valueMatchScore = StringHelper.basicWildcardMatchWithMatchScore(this.regexString, matchString);
            boolean matches = valueMatchScore >= 0;
            this.matchScore = matches ? new Long(valueMatchScore) : new Long(-1L);
            return matches;
        }
        throw new RuntimeException("Invalid matcher type: \"" + this.matcherType + "\"");
    }

    public String getRegexString() {
        return this.regexString;
    }

    public void setRegexString(String regexString) throws SSOException {
        if (StringHelper.isBlank(regexString)) {
            this.regexString = DEFAULT_REGEX_STRING;
        }
        this.regexString = regexString;
        if (this.matcherType == 2) {
            try {
                this.regexPattern = Pattern.compile(regexString);
            }
            catch (PatternSyntaxException e) {
                String errorString = "Invalid pattern while trying to set parameter name regex: " + regexString;
                log.error((Object)errorString, (Throwable)e);
                throw new SSOException(errorString, e);
            }
        }
    }

    public static int calculateMatchExpressionsHash(String matchString) {
        return matchString.hashCode();
    }

    public String toString() {
        return this.regexString;
    }
}

