/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http.configuration.matcher;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.URIMatcherHttpParam;

public class URIMatcherHttpParamSet {
    private static final Logger log = Logger.getLogger(URIMatcherHttpParamSet.class);
    private HashSet httpParamSet = new HashSet();

    public URIMatcherHttpParamSet() {
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public void addHttpParam(URIMatcherHttpParam httpParam) {
        this.httpParamSet.add(httpParam);
    }

    public void addMatchHttpParamSet(int matcherType, String name, String value) throws SSOException {
        URIMatcherHttpParam httpParam = new URIMatcherHttpParam(matcherType, name, value);
        this.addHttpParam(httpParam);
    }

    public boolean isEmpty() {
        if (this.httpParamSet == null) {
            return true;
        }
        Iterator it = this.httpParamSet.iterator();
        if (it == null) {
            return true;
        }
        return this.httpParamSet.isEmpty();
    }

    public boolean matches(Map httpParamMap, Map matchedParamsCache) {
        if (this.isEmpty()) {
            return true;
        }
        if (httpParamMap == null || httpParamMap.isEmpty()) {
            return false;
        }
        for (URIMatcherHttpParam httpParam : this.httpParamSet) {
            if (matchedParamsCache.containsKey(httpParam)) continue;
            boolean paramMatch = false;
            for (String name : httpParamMap.keySet()) {
                if (!httpParam.matchesName(name)) continue;
                String[] values = (String[])httpParamMap.get(name);
                if (values == null || values.length == 0) {
                    values = new String[]{""};
                }
                boolean valueMatches = false;
                for (int i = 0; i < values.length; ++i) {
                    if (!httpParam.matchesValue(values[i])) continue;
                    valueMatches = true;
                    break;
                }
                if (valueMatches) {
                    matchedParamsCache.put(name, httpParam);
                    paramMatch = true;
                    break;
                }
                return false;
            }
            if (paramMatch) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.httpParamSet.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (URIMatcherHttpParam param : this.httpParamSet) {
            sb.append(param.toString());
            sb.append("&");
        }
        String retVal = sb.toString();
        retVal = retVal.substring(0, retVal.length() - 2);
        return retVal;
    }
}

