/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.federation.passive.remotedata;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ws.federation.passive.remotedata.RemoteDataStorage;

public class RemoteDataServer {
    static final Logger log = Logger.getLogger(RemoteDataServer.class);

    public boolean isValidRemoteDataRequest(HttpServletRequest req) {
        if (!req.getMethod().equals("GET")) {
            log.debug((Object)"Remote Data Request validation: Non GET request");
            return false;
        }
        Enumeration en = req.getParameterNames();
        if (!(en.hasMoreElements() && en.nextElement() != null && !en.hasMoreElements())) {
            log.debug((Object)"Remote Data Request validation: Non-conforming profile. should have exactly 1 parm");
            return false;
        }
        String param = req.getParameter("wsfrdreq");
        if (param == null || param.trim().length() == 0) {
            log.debug((Object)"Remote Data Request validation: request parameter not found");
            return false;
        }
        RemoteDataStorage rds = RemoteDataStorage.getInstance();
        if (!rds.isValidKey(param)) {
            log.error((Object)("Remote Data Request validation: invalid paramter value:" + param));
            return false;
        }
        req.setAttribute("wsfrdrv", (Object)"true");
        return true;
    }

    public void serveRequest(HttpServletRequest req, HttpServletResponse resp) {
        String validRequestAttr = (String)req.getAttribute("wsfrdrv");
        if (!validRequestAttr.equals("true")) {
            log.warn((Object)"Remote Data Request serve called before validating request");
            if (!this.isValidRemoteDataRequest(req)) {
                log.error((Object)"Invalid remote data request");
                return;
            }
        }
        req.removeAttribute("wsfrdrv");
        String param = req.getParameter("wsfrdreq");
        RemoteDataStorage rds = RemoteDataStorage.getInstance();
        if (!rds.hasData(param)) {
            log.warn((Object)("Remote Data Request serve: no data found for uid=" + param));
            return;
        }
        String data = (String)rds.getDataWithRemove(param);
        if (data == null) {
            log.error((Object)("Remote Data Request serve: error extracting data from storage using uid=" + param));
            return;
        }
        PrintWriter writer = null;
        try {
            writer = resp.getWriter();
        }
        catch (IOException e) {
            log.error((Object)"Remote Data Request serve: Failed to get the response writer", (Throwable)e);
            return;
        }
        writer.println(data);
        rds.removeData(param);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Served Remote Data Request:" + data));
        }
    }
}

