/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.security.secext;

import org.apache.axiom.om.OMElement;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.Embedded;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.KeyIdentifier;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.Reference;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.SecurityTokenReference;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.impl.EmbeddedImpl;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.impl.KeyIdentifierImpl;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.impl.ReferenceImpl;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.impl.SecurityTokenReferenceImpl;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SignedSecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.impl.SAML1TokenImpl;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.impl.UsernameTokenImpl;

public class WSSecExtObjectBuilder {
    public static Embedded buildEmbedded(OMElement element) throws SSOException {
        return (Embedded)new EmbeddedImpl().fromOM(element);
    }

    public static KeyIdentifier buildKeyIdentifier(OMElement element) throws SSOException {
        return (KeyIdentifier)new KeyIdentifierImpl().fromOM(element);
    }

    public static Reference buildReference(OMElement element) throws SSOException {
        return (Reference)new ReferenceImpl().fromOM(element);
    }

    public static SecurityTokenReference buildSecurityTokenReference(OMElement element) throws SSOException {
        return (SecurityTokenReference)new SecurityTokenReferenceImpl().fromOM(element);
    }

    public static boolean isKnownSecurityToken(OMElement element) {
        try {
            if (new UsernameTokenImpl().isCompatibleElement(element)) {
                return true;
            }
            if (new SAML1TokenImpl().isCompatibleElement(element)) {
                return true;
            }
        }
        catch (SSOException sSOException) {
            // empty catch block
        }
        return false;
    }

    public static SecurityToken buildSecurityToken(OMElement element) throws SSOException {
        UsernameTokenImpl usernameToken = new UsernameTokenImpl();
        if (usernameToken.isCompatibleElement(element)) {
            return (SecurityToken)usernameToken.fromOM(element);
        }
        SAML1TokenImpl samlToken = new SAML1TokenImpl();
        if (samlToken.isCompatibleElement(element)) {
            return (SecurityToken)samlToken.fromOM(element);
        }
        return null;
    }

    public static SignedSecurityToken buildSignedSecurityToken(OMElement element) throws SSOException {
        SAML1TokenImpl samlToken = new SAML1TokenImpl();
        if (samlToken.isCompatibleElement(element)) {
            return (SignedSecurityToken)samlToken.fromOM(element);
        }
        return null;
    }
}

