/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.security.secext.element.impl;

import java.util.Iterator;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.GenericAttribute;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.WSSecExt;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.WSSecExtObjectBuilder;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.Embedded;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.KeyIdentifier;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.Reference;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.SecurityTokenReference;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.impl.BaseWSSecExtObjectImpl;

public class SecurityTokenReferenceImpl
extends BaseWSSecExtObjectImpl
implements SecurityTokenReference {
    private static final Logger log = Logger.getLogger(SecurityTokenReferenceImpl.class);
    protected WSSecExt wsse;
    protected String id;
    protected String tokenType;
    protected Embedded embedded;
    protected KeyIdentifier keyIdentifier;
    protected Reference reference;

    public SecurityTokenReferenceImpl() {
        this.reset();
        this.wsse = new WSSecExt();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating wsse:SecurityTokenReference object");
        }
    }

    public SecurityTokenReferenceImpl(WSSecExt wsse) {
        this.reset();
        this.wsse = wsse;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating wsse:SecurityTokenReference object");
        }
    }

    public void reset() {
        super.reset();
        this.id = null;
        this.tokenType = null;
        this.embedded = null;
        this.keyIdentifier = null;
        this.reference = null;
    }

    public void copyFrom(BaseWSInterface other) {
        super.copyFrom(other);
        if (other instanceof SecurityTokenReferenceImpl) {
            SecurityTokenReferenceImpl otherSecurityTokenReferenceImpl = (SecurityTokenReferenceImpl)other;
            this.wsse = otherSecurityTokenReferenceImpl.wsse;
            this.id = otherSecurityTokenReferenceImpl.id;
            this.tokenType = otherSecurityTokenReferenceImpl.tokenType;
            this.embedded = otherSecurityTokenReferenceImpl.embedded;
            this.reference = otherSecurityTokenReferenceImpl.reference;
        }
    }

    public String getLocalName() {
        return "SecurityTokenReference";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        this.setDirty();
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
        this.setDirty();
    }

    public Embedded getEmbedded() {
        return this.embedded;
    }

    public void setEmbedded(Embedded embedded) {
        this.embedded = embedded;
        this.setDirty();
    }

    public KeyIdentifier getKeyIdentifier() {
        return this.keyIdentifier;
    }

    public void setKeyIdentifier(KeyIdentifier keyIdentifier) {
        this.keyIdentifier = keyIdentifier;
        this.setDirty();
    }

    public Reference getReference() {
        return this.reference;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
        this.setDirty();
    }

    public OMElement toOM() {
        return this.toOM(null);
    }

    public OMElement toOM(OMElement parent) {
        if (!this.isParseSourceDirty()) {
            if (parent != null) {
                parent.addChild((OMNode)this.getParseSource());
            }
            return this.getParseSource();
        }
        return null;
    }

    public boolean isCompatibleElement(OMElement element) throws SSOException {
        return this.baseIsCompatibleElementSecExt(element, this.getLocalName()) != null;
    }

    public BaseWSInterface fromOM(OMElement element) throws SSOException {
        WSSecExt wsse = this.baseIsCompatibleElementSecExt(element, this.getLocalName());
        if (wsse == null) {
            return null;
        }
        String localName = element.getLocalName();
        SecurityTokenReferenceImpl securityTokenReference = new SecurityTokenReferenceImpl(wsse);
        Iterator it = element.getAllAttributes();
        if (it != null) {
            while (it.hasNext()) {
                OMAttribute attr = (OMAttribute)it.next();
                if (attr.getLocalName().equals("Id")) {
                    securityTokenReference.id = attr.getAttributeValue();
                    continue;
                }
                if (attr.getLocalName().equals("TokenType")) {
                    securityTokenReference.tokenType = attr.getAttributeValue();
                    continue;
                }
                securityTokenReference._anyAttr.add(new GenericAttribute(attr.getLocalName(), attr.getAttributeValue()));
            }
        }
        if ((it = element.getChildElements()) != null) {
            while (it.hasNext()) {
                OMElement workEl = (OMElement)it.next();
                localName = workEl.getLocalName();
                if ("KeyIdentifier".equals(localName)) {
                    KeyIdentifier keyIdentifier;
                    securityTokenReference.keyIdentifier = keyIdentifier = WSSecExtObjectBuilder.buildKeyIdentifier(workEl);
                    continue;
                }
                if ("Reference".equals(localName)) {
                    Reference reference;
                    securityTokenReference.reference = reference = WSSecExtObjectBuilder.buildReference(workEl);
                    continue;
                }
                if ("Embedded".equals(localName)) {
                    Embedded embedded;
                    securityTokenReference.embedded = embedded = WSSecExtObjectBuilder.buildEmbedded(workEl);
                    continue;
                }
                securityTokenReference._anyElement.add(workEl);
            }
        }
        securityTokenReference.setParseSource(element);
        this.copyFrom(securityTokenReference);
        return this;
    }
}

