/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.trust;

import java.util.Date;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ws.model.addressing.element.EndpointReference;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.SecurityTokenReference;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrust;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrustVersion;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.AuthenticationType;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.CancelTarget;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.Claims;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.Issuer;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.Lifetime;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.OnBehalfOf;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestSecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestSecurityTokenResponse;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestType;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestedAttachedReference;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestedSecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestedTokenCancelled;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestedUnattachedReference;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.TokenType;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.AuthenticationTypeImpl;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.CancelTargetImpl;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.ClaimsImpl;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.IssuerImpl;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.LifetimeImpl;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.OnBehalfOfImpl;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.RequestSecurityTokenImpl;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.RequestSecurityTokenResponseImpl;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.RequestTypeImpl;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.RequestedAttachedReferenceImpl;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.RequestedSecurityTokenImpl;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.RequestedTokenCancelledImpl;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.RequestedUnattachedReferenceImpl;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.TokenTypeImpl;

public class WSTrustObjectFactory {
    static final Logger log = Logger.getLogger(WSTrustObjectFactory.class);
    protected WSTrust wst = null;

    public WSTrustObjectFactory() {
        this.wst = new WSTrust();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Created instance of WSTrustObjectFactory() object");
        }
    }

    public WSTrustObjectFactory(WSTrust wst) {
        this.wst = wst;
    }

    public WSTrustObjectFactory(WSTrustVersion version) {
        this.wst = new WSTrust(version);
    }

    public RequestSecurityToken createRequestSecurityToken() {
        return new RequestSecurityTokenImpl(this.wst);
    }

    public Lifetime createLifetime() {
        return new LifetimeImpl(this.wst);
    }

    public Lifetime createLifetime(Date created, Date expires) {
        return new LifetimeImpl(this.wst, created, expires);
    }

    public Lifetime createLifetime(long created, long expires) {
        return new LifetimeImpl(this.wst, created, expires);
    }

    public RequestType createRequestType() {
        return new RequestTypeImpl(this.wst);
    }

    public RequestType createRequestType(String requestType) {
        return new RequestTypeImpl(this.wst, requestType);
    }

    public TokenType createTokenType() {
        return new TokenTypeImpl(this.wst);
    }

    public TokenType createTokenType(String tokenType) {
        return new TokenTypeImpl(this.wst, tokenType);
    }

    public RequestSecurityTokenResponse createRequestSecurityTokenResponse() {
        return new RequestSecurityTokenResponseImpl(this.wst);
    }

    public OnBehalfOf createOnBehalfOf() {
        return new OnBehalfOfImpl(this.wst);
    }

    public Issuer createIssuer() {
        return new IssuerImpl(this.wst);
    }

    public Issuer createIssuer(EndpointReference epr) {
        return new IssuerImpl(this.wst, epr);
    }

    public AuthenticationType createAuthenticationType() {
        return new AuthenticationTypeImpl(this.wst);
    }

    public AuthenticationType createAuthenticationType(String authenticationType) {
        return new AuthenticationTypeImpl(this.wst, authenticationType);
    }

    public RequestedAttachedReference createRequestedAttachedReference() {
        return new RequestedAttachedReferenceImpl(this.wst);
    }

    public RequestedAttachedReference createRequestedAttachedReference(SecurityTokenReference securityTokenReference) {
        return new RequestedAttachedReferenceImpl(this.wst, securityTokenReference);
    }

    public RequestedUnattachedReference createRequestedUnattachedReference() {
        return new RequestedUnattachedReferenceImpl(this.wst);
    }

    public RequestedUnattachedReference createRequestedUnattachedReference(SecurityTokenReference securityTokenReference) {
        return new RequestedUnattachedReferenceImpl(this.wst, securityTokenReference);
    }

    public CancelTarget createCancelTarget() {
        return new CancelTargetImpl(this.wst);
    }

    public RequestedTokenCancelled createRequestedTokenCancelled() {
        return new RequestedTokenCancelledImpl(this.wst);
    }

    public Claims createClaims() {
        return new ClaimsImpl(this.wst);
    }

    public RequestedSecurityToken createRequestedSecurityToken() {
        return new RequestedSecurityTokenImpl(this.wst);
    }
}

