/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.trust.element.impl;

import java.util.Date;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.WSAbstractFactory;
import org.eclipse.alf.security.sso.common.ws.model.security.utility.WSSecUtilityObjectBuilder;
import org.eclipse.alf.security.sso.common.ws.model.security.utility.element.Created;
import org.eclipse.alf.security.sso.common.ws.model.security.utility.element.Expires;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrust;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.Lifetime;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.BaseWSTrustObjectImpl;

public class LifetimeImpl
extends BaseWSTrustObjectImpl
implements Lifetime {
    private static final Logger log = Logger.getLogger(LifetimeImpl.class);
    protected WSTrust wst;
    protected Created created;
    protected Expires expires;

    public LifetimeImpl() {
        this.reset();
        this.wst = new WSTrust();
    }

    public LifetimeImpl(WSTrust wst) {
        this.reset();
        this.wst = wst;
    }

    public LifetimeImpl(WSTrust wst, Date created, Date expires) {
        this.reset();
        this.wst = wst;
        this.created = WSAbstractFactory.getWSSUObjectFactory().createCreated(created);
        this.expires = WSAbstractFactory.getWSSUObjectFactory().createExpires(expires);
    }

    public LifetimeImpl(WSTrust wst, long created, long expires) {
        this.reset();
        this.wst = wst;
        this.created = WSAbstractFactory.getWSSUObjectFactory().createCreated(new Date(created));
        this.expires = WSAbstractFactory.getWSSUObjectFactory().createExpires(new Date(expires));
    }

    public String getLocalName() {
        return "Lifetime";
    }

    public void reset() {
        super.reset();
        this.created = null;
        this.expires = null;
    }

    public void copyFrom(BaseWSInterface other) {
        super.copyFrom(other);
        if (other instanceof LifetimeImpl) {
            LifetimeImpl otherLifetimeImpl = (LifetimeImpl)other;
            this.wst = otherLifetimeImpl.wst;
            this.created = otherLifetimeImpl.created;
            this.expires = otherLifetimeImpl.expires;
        }
    }

    public void set(Date created, Date expires) {
        this.created = WSAbstractFactory.getWSSUObjectFactory().createCreated(created);
        this.expires = WSAbstractFactory.getWSSUObjectFactory().createExpires(expires);
        this.setDirty();
    }

    public void set(long created, long expires) {
        this.created = WSAbstractFactory.getWSSUObjectFactory().createCreated(new Date(created));
        this.expires = WSAbstractFactory.getWSSUObjectFactory().createExpires(new Date(expires));
        this.setDirty();
    }

    public void setCreated(Created created) {
        this.created = created;
        this.setDirty();
    }

    public void setCreated(Date created) {
        this.created = WSAbstractFactory.getWSSUObjectFactory().createCreated(created);
        this.setDirty();
    }

    public void setExpires(Expires expires) {
        this.expires = expires;
        this.setDirty();
    }

    public void setExpires(Date expires) {
        this.expires = WSAbstractFactory.getWSSUObjectFactory().createExpires(expires);
        this.setDirty();
    }

    public Created getCreated() {
        return this.created;
    }

    public Date getCreatedAsDate() {
        if (this.created != null) {
            return this.created.getCreated();
        }
        return null;
    }

    public Expires getExpires() {
        return this.expires;
    }

    public Date getExpiresAsDate() {
        if (this.expires != null) {
            return this.expires.getExpires();
        }
        return null;
    }

    public OMElement toOM() {
        return this.toOM(null);
    }

    public OMElement toOM(OMElement parent) {
        if (!this.isParseSourceDirty()) {
            if (parent != null) {
                parent.addChild((OMNode)this.getParseSource());
            }
            return this.getParseSource();
        }
        OMElement lifetimeEl = this.wst.createOMElement(parent, this.getLocalName());
        this.created.toOM(lifetimeEl);
        this.expires.toOM(lifetimeEl);
        this.addAnyAttributesToElement(lifetimeEl);
        this.addAnyElementsToElementAsChildren(lifetimeEl);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created " + this.getLocalName() + " object:[" + lifetimeEl.toString() + "]"));
        }
        return lifetimeEl;
    }

    public boolean isCompatibleElement(OMElement element) throws SSOException {
        return this.baseIsCompatibleElementTrust(element, this.getLocalName()) != null;
    }

    public BaseWSInterface fromOM(OMElement element) throws SSOException {
        WSTrust wst = this.baseIsCompatibleElementTrust(element, this.getLocalName());
        if (wst == null) {
            return null;
        }
        LifetimeImpl lifetime = new LifetimeImpl(wst);
        Iterator it = element.getChildElements();
        if (it != null) {
            while (it.hasNext()) {
                OMElement workEl = (OMElement)it.next();
                String localName = workEl.getLocalName();
                if ("Created".equals(localName)) {
                    lifetime.created = WSSecUtilityObjectBuilder.buildCreated(workEl);
                    continue;
                }
                if ("Expires".equals(localName)) {
                    lifetime.expires = WSSecUtilityObjectBuilder.buildExpires(workEl);
                    continue;
                }
                lifetime._anyElement.add(workEl.cloneOMElement());
            }
        }
        lifetime.setParseSource(element);
        this.copyFrom(lifetime);
        return this;
    }

    public WSTrust getWSTrust() {
        return this.wst;
    }
}

