/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.trust.element.impl;

import java.util.Iterator;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.GenericAttribute;
import org.eclipse.alf.security.sso.common.ws.model.policy.WSPolicyObjectBuilder;
import org.eclipse.alf.security.sso.common.ws.model.policy.element.AppliesTo;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrust;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrustObjectBuilder;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.AuthenticationType;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.BinarySecret;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.CancelTarget;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.Claims;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.Entropy;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.Issuer;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.Lifetime;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.OnBehalfOf;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RenewTarget;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestSecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestType;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.SecondaryParameters;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.TokenType;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.ValidateTarget;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.BaseWSTrustObjectImpl;

public class RequestSecurityTokenImpl
extends BaseWSTrustObjectImpl
implements RequestSecurityToken {
    private static final Logger log = Logger.getLogger(RequestSecurityTokenImpl.class);
    protected WSTrust wst;
    protected String contextAttribute;
    protected Lifetime lifetime;
    protected BinarySecret binarySecret;
    protected RequestType requestType;
    protected TokenType tokenType;
    protected AppliesTo appliesTo;
    protected OnBehalfOf onBehalfOf;
    protected Issuer issuer;
    protected AuthenticationType authenticationType;
    protected CancelTarget cancelTarget;
    protected RenewTarget renewTarget;
    protected ValidateTarget validateTarget;
    protected Entropy entropy;
    protected Claims claims;
    protected SecondaryParameters secondaryParameters;

    public RequestSecurityTokenImpl() {
        this.reset();
        this.wst = new WSTrust();
    }

    public RequestSecurityTokenImpl(WSTrust wst) {
        this.reset();
        this.wst = wst;
    }

    public String getLocalName() {
        return "RequestSecurityToken";
    }

    public void reset() {
        super.reset();
        this.contextAttribute = null;
        this.lifetime = null;
        this.binarySecret = null;
        this.requestType = null;
        this.tokenType = null;
        this.appliesTo = null;
        this.onBehalfOf = null;
        this.issuer = null;
        this.authenticationType = null;
        this.cancelTarget = null;
        this.renewTarget = null;
        this.validateTarget = null;
        this.entropy = null;
        this.claims = null;
        this.secondaryParameters = null;
    }

    public void copyFrom(BaseWSInterface other) {
        super.copyFrom(other);
        if (other instanceof RequestSecurityTokenImpl) {
            RequestSecurityTokenImpl otherRequestSecurityTokenImpl = (RequestSecurityTokenImpl)other;
            this.wst = otherRequestSecurityTokenImpl.wst;
            this.contextAttribute = otherRequestSecurityTokenImpl.contextAttribute;
            this.lifetime = otherRequestSecurityTokenImpl.lifetime;
            this.binarySecret = otherRequestSecurityTokenImpl.binarySecret;
            this.requestType = otherRequestSecurityTokenImpl.requestType;
            this.tokenType = otherRequestSecurityTokenImpl.tokenType;
            this.appliesTo = otherRequestSecurityTokenImpl.appliesTo;
            this.onBehalfOf = otherRequestSecurityTokenImpl.onBehalfOf;
            this.issuer = otherRequestSecurityTokenImpl.issuer;
            this.authenticationType = otherRequestSecurityTokenImpl.authenticationType;
            this.cancelTarget = otherRequestSecurityTokenImpl.cancelTarget;
            this.renewTarget = otherRequestSecurityTokenImpl.renewTarget;
            this.validateTarget = otherRequestSecurityTokenImpl.validateTarget;
            this.entropy = otherRequestSecurityTokenImpl.entropy;
            this.claims = otherRequestSecurityTokenImpl.claims;
            this.secondaryParameters = otherRequestSecurityTokenImpl.secondaryParameters;
        }
    }

    public void setContextAttribute(String context) {
        this.contextAttribute = context;
    }

    public String getContextAttribute() {
        return this.contextAttribute;
    }

    public void setLifetime(Lifetime lifetime) {
        this.lifetime = lifetime;
        this.setDirty();
    }

    public Lifetime getLifetime() {
        return this.lifetime;
    }

    public void setRequestType(RequestType requestType) {
        this.requestType = requestType;
        this.setDirty();
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
        this.setDirty();
    }

    public AppliesTo getAppliesTo() {
        return this.appliesTo;
    }

    public void setAppliesTo(AppliesTo appliesTo) {
        this.appliesTo = appliesTo;
        this.setDirty();
    }

    public OnBehalfOf getOnBehalfOf() {
        return this.onBehalfOf;
    }

    public void setOnBehalfOf(OnBehalfOf onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
        this.setDirty();
    }

    public void setIssuer(Issuer issuer) {
        this.issuer = issuer;
        this.setDirty();
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public void setAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        this.setDirty();
    }

    public AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public CancelTarget getCancelTarget() {
        return this.cancelTarget;
    }

    public void setCancelTarget(CancelTarget cancelTarget) {
        this.cancelTarget = cancelTarget;
        this.setDirty();
    }

    public RenewTarget getRenewTarget() {
        return this.renewTarget;
    }

    public void setRenewTarget(RenewTarget renewTarget) {
        this.renewTarget = renewTarget;
        this.setDirty();
    }

    public ValidateTarget getValidateTarget() {
        return this.validateTarget;
    }

    public Entropy getEntropy() {
        return this.entropy;
    }

    public void setEntropy(Entropy entropy) {
        this.entropy = entropy;
        this.setDirty();
    }

    public void setValidateTarget(ValidateTarget validateTarget) {
        this.validateTarget = validateTarget;
        this.setDirty();
    }

    public Claims getClaims() {
        return this.claims;
    }

    public void setClaims(Claims claims) {
        this.claims = claims;
        this.setDirty();
    }

    public SecondaryParameters getSecondaryParameters() {
        return this.secondaryParameters;
    }

    public void setSecondaryParameters(SecondaryParameters secondaryParameters) {
        this.secondaryParameters = secondaryParameters;
        this.setDirty();
    }

    public OMElement toOM() {
        return this.toOM(null);
    }

    public OMElement toOM(OMElement parent) {
        log.debug((Object)"RequestSecurityTokenImpl.toOM()");
        if (!this.isParseSourceDirty()) {
            if (parent != null) {
                parent.addChild((OMNode)this.getParseSource());
            }
            return this.getParseSource();
        }
        OMElement rstEl = this.wst.createOMElement(parent, this.getLocalName());
        if (this.contextAttribute != null) {
            OMAttribute attr = OMAbstractFactory.getOMFactory().createOMAttribute("Context", this.wst.getOMNamespace(), this.contextAttribute);
            rstEl.addAttribute(attr);
        }
        if (this.requestType != null) {
            this.requestType.toOM(rstEl);
        }
        if (this.tokenType != null) {
            this.tokenType.toOM(rstEl);
        }
        if (this.appliesTo != null) {
            this.appliesTo.toOM(rstEl);
        }
        if (this.lifetime != null) {
            this.lifetime.toOM(rstEl);
        }
        if (this.onBehalfOf != null) {
            this.onBehalfOf.toOM(rstEl);
        }
        if (this.issuer != null) {
            this.issuer.toOM(rstEl);
        }
        if (this.authenticationType != null) {
            this.authenticationType.toOM(rstEl);
        }
        if (this.cancelTarget != null) {
            this.cancelTarget.toOM(rstEl);
        }
        if (this.renewTarget != null) {
            this.renewTarget.toOM(rstEl);
        }
        if (this.validateTarget != null) {
            this.validateTarget.toOM(rstEl);
        }
        if (this.entropy != null) {
            this.entropy.toOM(rstEl);
        }
        if (this.claims != null) {
            this.claims.toOM(rstEl);
        }
        if (this.binarySecret != null) {
            this.binarySecret.toOM(rstEl);
        }
        if (this.secondaryParameters != null) {
            this.secondaryParameters.toOM(rstEl);
        }
        this.addAnyAttributesToElement(rstEl);
        this.addAnyElementsToElementAsChildren(rstEl);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created RST request:" + rstEl.toString()));
        }
        return rstEl;
    }

    public boolean isCompatibleElement(OMElement element) throws SSOException {
        return this.baseIsCompatibleElementTrust(element, this.getLocalName()) != null;
    }

    public BaseWSInterface fromOM(OMElement element) throws SSOException {
        WSTrust wst = this.baseIsCompatibleElementTrust(element, this.getLocalName());
        if (wst == null) {
            return null;
        }
        log.debug((Object)"Parsing <wst:RequestSecurityToken> element");
        RequestSecurityTokenImpl requestSecurityToken = new RequestSecurityTokenImpl(wst);
        Iterator it = element.getAllAttributes();
        while (it.hasNext()) {
            OMAttribute attr = (OMAttribute)it.next();
            if (attr.getLocalName().equals("Context") && attr.getNamespace().getNamespaceURI().equals(wst.getNamespace())) {
                requestSecurityToken.contextAttribute = attr.getAttributeValue();
            }
            requestSecurityToken._anyAttr.add(new GenericAttribute(attr.getLocalName(), attr.getAttributeValue()));
        }
        it = element.getChildElements();
        if (it != null) {
            while (it != null && it.hasNext()) {
                OMElement workEl = (OMElement)it.next();
                String localName = workEl.getLocalName();
                if ("RequestType".equals(localName)) {
                    requestSecurityToken.requestType = WSTrustObjectBuilder.buildRequestType(workEl);
                    continue;
                }
                if ("BinarySecret".equals(localName)) {
                    requestSecurityToken.binarySecret = WSTrustObjectBuilder.buildBinarySecret(workEl);
                    continue;
                }
                if ("TokenType".equals(localName)) {
                    requestSecurityToken.tokenType = WSTrustObjectBuilder.buildTokenType(workEl);
                    continue;
                }
                if ("AppliesTo".equals(localName)) {
                    requestSecurityToken.appliesTo = WSPolicyObjectBuilder.buildAppliesTo(workEl);
                    continue;
                }
                if ("Lifetime".equals(localName)) {
                    requestSecurityToken.lifetime = WSTrustObjectBuilder.buildLifetime(workEl);
                    continue;
                }
                if ("OnBehalfOf".equals(localName)) {
                    requestSecurityToken.onBehalfOf = WSTrustObjectBuilder.buildOnBehalfOf(workEl);
                    continue;
                }
                if ("CancelTarget".equals(localName)) {
                    requestSecurityToken.cancelTarget = WSTrustObjectBuilder.buildCancelTarget(workEl);
                    continue;
                }
                if ("RenewTarget".equals(localName)) {
                    requestSecurityToken.renewTarget = WSTrustObjectBuilder.buildRenewTarget(workEl);
                    continue;
                }
                if ("ValidateTarget".equals(localName)) {
                    requestSecurityToken.validateTarget = WSTrustObjectBuilder.buildValidateTarget(workEl);
                    continue;
                }
                if ("Entropy".equals(localName)) {
                    requestSecurityToken.cancelTarget = WSTrustObjectBuilder.buildCancelTarget(workEl);
                    continue;
                }
                if ("Claims".equals(localName)) {
                    requestSecurityToken.claims = WSTrustObjectBuilder.buildClaims(workEl);
                    continue;
                }
                if ("SecondaryParameters".equals(localName)) {
                    requestSecurityToken.secondaryParameters = WSTrustObjectBuilder.buildSecondaryParameters(workEl);
                    continue;
                }
                requestSecurityToken._anyElement.add(workEl.cloneOMElement());
            }
        }
        this.setParseSource(element);
        this.copyFrom(requestSecurityToken);
        return this;
    }

    public WSTrust getWSTrust() {
        return this.wst;
    }
}

