/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.util.UIDGenerator;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedData;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.remotedata.RemoteDataStorage;
import org.eclipse.alf.security.sso.server.federationserver.RequestContext;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvConfig;
import org.eclipse.alf.security.sso.server.federationserver.config.IssuedTokensData;

public class PageRedirector {
    private static Logger log = Logger.getLogger(PageRedirector.class);
    public static final String RD_PARAM = "rd";
    public static final String METHOD_PARAM = "rm";
    public static final String METHOD_ATTR = "redirectMethod";
    public static final String ERROR_MSG_STR_ATTR = "errorMessage";

    private PageRedirector() {
    }

    public static void redirectAppError(HttpServletRequest req, HttpServletResponse resp, RequestContext requestContext, String errorMessage) throws ServletException {
        log.info((Object)("Redirecting to application error page. error=\"" + errorMessage + "\""));
        String page = requestContext.getRpConfig().getCoreConfig().getParameter("PageError", "jsp/appError.jsp");
        req.setAttribute(ERROR_MSG_STR_ATTR, (Object)errorMessage);
        RequestDispatcher rd = req.getRequestDispatcher(page);
        try {
            rd.forward((ServletRequest)req, (ServletResponse)resp);
        }
        catch (IOException e) {
            log.error((Object)("Error forwarding to app error page: " + e));
            throw new ServletException();
        }
    }

    public static void redrectDirectFobidden(HttpServletRequest req, HttpServletResponse resp, RequestContext requestContext) throws ServletException {
        log.debug((Object)"Redirecting to 'direct access forbidden' page");
        String page = requestContext.getRpConfig().getCoreConfig().getParameter("PageDirectAccessForbidden", "jsp/directAccessForbidden.jsp");
        if (StringHelper.isBlank((String)page)) {
            try {
                resp.sendError(403, "Please use single-sign-on enabled application to login");
            }
            catch (IOException e) {
                String errorMessage = "Error forwarding to 'direct access forbidden' page";
                log.error((Object)errorMessage, (Throwable)e);
                throw new ServletException(errorMessage, (Throwable)e);
            }
        }
        RequestDispatcher rd = req.getRequestDispatcher(page);
        try {
            rd.forward((ServletRequest)req, (ServletResponse)resp);
        }
        catch (IOException e) {
            log.error((Object)("Error forwarding to 'direct access forbidden' page: " + e));
            throw new ServletException();
        }
    }

    public static void redrectBack(HttpServletRequest req, HttpServletResponse resp, RequestContext requestContext) throws ServletException {
        String redirectMethod = requestContext.getRpConfig().getCoreConfig().getParameter("HttpRedirectMethod", "GET");
        if (StringHelper.isBlank((String)redirectMethod) || !redirectMethod.equalsIgnoreCase("GET") && !redirectMethod.equalsIgnoreCase("POST")) {
            log.error((Object)"Invalid value for parameter \"HttpRedirectMethod\": only \"POST\" and \"GET\" are allowed values. Defaulting to \"GET\"");
            redirectMethod = "GET";
        }
        String pageRedirect = requestContext.getRpConfig().getCoreConfig().getParameter("PageRedirect", "jsp/postRedirect.jsp");
        boolean httpRedirectSecWarnAvoidance = requestContext.getRpConfig().getCoreConfig().getBooleanParameter("HttpRedirectHttpsSecurityWarningAvoidance", true);
        boolean forceRemoteData = requestContext.getRpConfig().getCoreConfig().getBooleanParameter("ForceRemoteDataInWSFederation", false);
        int maxUrlLen = requestContext.getRpConfig().getCoreConfig().getIntParameter("RemoteDataMaxURLLength", 260);
        long remoteDataTTL = requestContext.getRpConfig().getCoreConfig().getLongParameter("RemoteDataTTL", 60L);
        String remoteDataURI = requestContext.getRpConfig().getCoreConfig().getParameter("RemoteDataServerEPR", "");
        String redirectTarget = pageRedirect;
        WSFedHelper.setWSFDataAsAttributes((HttpServletRequest)req, (WSFedData)requestContext.getOutboundWsfData());
        req.setAttribute(METHOD_ATTR, (Object)redirectMethod);
        req.getSession().removeAttribute("ATTR_REQUEST_CONTEXT");
        req.getSession().invalidate();
        if (req.isSecure() && httpRedirectSecWarnAvoidance) {
            Integer httpConnectorPort;
            try {
                String httpConnectorPortStr = requestContext.getRpConfig().getCoreConfig().getParameter("HttpRedirectConnectorPort", "80");
                httpConnectorPort = httpConnectorPortStr.trim().length() == 0 ? null : Integer.valueOf(httpConnectorPortStr);
            }
            catch (NumberFormatException e) {
                try {
                    httpConnectorPort = Integer.valueOf("80");
                }
                catch (NumberFormatException ee) {
                    log.error((Object)"This should never happen.");
                    httpConnectorPort = null;
                }
            }
            String url = req.getRequestURL().toString();
            String servletPath = req.getServletPath();
            int offset = url.indexOf(servletPath);
            String prefix = url.substring(0, offset);
            URL prefixURL = null;
            try {
                prefixURL = new URL(prefix);
            }
            catch (MalformedURLException e) {
                log.error((Object)("Error forwarding to app error page: " + e));
                throw new ServletException();
            }
            URL newPrefixURL = null;
            try {
                newPrefixURL = httpConnectorPort == null ? new URL("http", prefixURL.getHost(), prefixURL.getFile()) : new URL("http", prefixURL.getHost(), httpConnectorPort, prefixURL.getFile());
            }
            catch (MalformedURLException e) {
                log.error((Object)("Error forwarding to app error page: " + e));
                throw new ServletException();
            }
            redirectTarget = newPrefixURL.toString() + "/" + pageRedirect;
            RemoteDataStorage rd = RemoteDataStorage.getInstance();
            String rdKey = rd.add((Object)requestContext.getOutboundWsfData(), remoteDataTTL);
            redirectTarget = redirectTarget + "?" + RD_PARAM + "=" + rdKey;
            redirectTarget = redirectTarget + "&" + METHOD_PARAM + "=" + redirectMethod;
            try {
                resp.sendRedirect(redirectTarget);
            }
            catch (IOException e) {
                log.error((Object)("Error forwarding to app error page: " + e));
                throw new ServletException();
            }
        }
        try {
            RequestDispatcher rd = req.getRequestDispatcher(redirectTarget);
            rd.forward((ServletRequest)req, (ServletResponse)resp);
        }
        catch (IOException e) {
            log.error((Object)("Error forwarding to app error page: " + e));
            throw new ServletException();
        }
    }

    public static void redirectRemoveParams(HttpServletRequest req, HttpServletResponse resp, RequestContext requestContext) throws ServletException {
        req.getSession().setAttribute("ATTR_REQUEST_CONTEXT", (Object)requestContext);
        req.getSession().setAttribute("ATTR_PARAMS_REMOVED_FROM_URL", (Object)"1");
        try {
            resp.sendRedirect(req.getRequestURI());
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public static void redirectToLoginPage(HttpServletRequest req, HttpServletResponse resp, RequestContext requestContext, String message) throws ServletException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Redirecting to login page");
        }
        String loginPage = requestContext.getRpConfig().getCoreConfig().getParameter("PageLogin", "jsp/login.jsp");
        req.getSession().setAttribute("ATTR_REQUEST_CONTEXT", (Object)requestContext);
        req.setAttribute("ATTR_MESSAGE", (Object)(message == null ? "" : message));
        req.setAttribute("ATTR_RP_FRIENDLY_NAME", (Object)requestContext.getRpConfig().getRPFriendlyName());
        req.setAttribute("ATTR_WREPLY", (Object)requestContext.getInboundWsfData().getWreply());
        String secret = UIDGenerator.getUUID();
        req.getSession().setAttribute("ATTR_LOGINPAGE_SECRET", (Object)secret);
        req.setAttribute("ATTR_OPAQUE", (Object)DigestUtils.shaHex((String)secret));
        try {
            RequestDispatcher rd = req.getRequestDispatcher(loginPage);
            rd.forward((ServletRequest)req, (ServletResponse)resp);
        }
        catch (IOException e) {
            log.error((Object)("Error sending redirect: " + e));
            throw new ServletException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void redirectToLogoutPage(HttpServletRequest req, HttpServletResponse resp, RequestContext requestContext) throws ServletException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Redirecting to logout page");
        }
        String page = requestContext.getRpConfig().getCoreConfig().getParameter("PageLogout", "jsp/logout.jsp");
        ArrayList<String> logoutURLs = new ArrayList<String>();
        HashSet<String> logourFiendlyNames = new HashSet<String>();
        if (requestContext.getCanceledToken() != null) {
            req.setAttribute("ATTR_LOGOUT_SUBJECT", (Object)requestContext.getCanceledToken().getSubjectName());
            String tokenId = requestContext.getCanceledToken().getId();
            ArrayList authenticatedServices = (ArrayList)FedSrvConfig.getInstance().getIssuedTokens().get((Object)tokenId);
            if (authenticatedServices != null) {
                ArrayList arrayList = authenticatedServices;
                synchronized (arrayList) {
                    for (int i = 0; i < authenticatedServices.size(); ++i) {
                        IssuedTokensData data = (IssuedTokensData)authenticatedServices.get(i);
                        String url = data.getIssueURL();
                        String rpFriendlyName = data.getRpConfig().getRPFriendlyName();
                        int paramsIdx = url.indexOf(63);
                        if (paramsIdx > 0) {
                            url = url.substring(0, paramsIdx);
                        }
                        url = url + "?wa=wsignoutcleanup1.0";
                        logoutURLs.add(url);
                        logourFiendlyNames.add(rpFriendlyName);
                    }
                }
            }
            FedSrvConfig.getInstance().getIssuedTokens().remove((Object)tokenId);
        }
        req.setAttribute("ATTR_LOGOUT_SIGNOUT_URLS", logoutURLs);
        req.setAttribute("ATTR_SIGNOUT_SERVICE_NAMES", logourFiendlyNames);
        req.setAttribute("ATTR_WREPLY", (Object)requestContext.getInboundWsfData().getWreply());
        RequestDispatcher rd = req.getRequestDispatcher(page);
        try {
            rd.forward((ServletRequest)req, (ServletResponse)resp);
        }
        catch (IOException e) {
            log.error((Object)("Error forwarding to logout page: " + e));
            throw new ServletException();
        }
    }
}

