/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver.config;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ExpirableMap;
import org.eclipse.alf.security.sso.common.RPURI;
import org.eclipse.alf.security.sso.common.http.configuration.PKIConfig;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvRPConfig;
import org.opensaml.SAMLConfig;

public class FedSrvConfig {
    private static final Logger log = Logger.getLogger(FedSrvConfig.class);
    public static final String DEFAULT_CONFIG_FILENAME = "fedsvr-services-config.xml";
    public static final String DEFAULT_CONFDIR_LOCATION = "/WEB-INF/conf";
    public static final String PROPNAME_ROOT_PATH = "ROOT_PATH";
    public static final String PROPNAME_CFG_NAME = "LogonUIConfigName";
    public static final String SYSPROP_CFG_NAME = "org.eclipse.alf.security.sso.server.fedsrv.conf-name";
    protected PKIConfig pkiConfig;
    protected ArrayList rpConfigs;
    protected FedSrvRPConfig defaultRpConfig;
    protected ExpirableMap issuedTokensData;

    public FedSrvConfig() {
        this.reset();
        SAMLConfig.instance();
    }

    public void reset() {
        this.pkiConfig = new PKIConfig();
        this.rpConfigs = new ArrayList();
        this.defaultRpConfig = null;
        this.issuedTokensData = new ExpirableMap();
    }

    public static synchronized FedSrvConfig getInstance() {
        return FedSrvConfigHolder.instance;
    }

    public static synchronized void setInstance(FedSrvConfig newInstance) {
        FedSrvConfigHolder.instance = newInstance;
    }

    public void addRPConfig(FedSrvRPConfig rpConfig) {
        this.rpConfigs.add(rpConfig);
    }

    public FedSrvRPConfig getRPConfig(String rpuriString) {
        if (rpuriString == null) {
            throw new IllegalArgumentException("Relying Rarty URI cannot be null");
        }
        RPURI rpuri = RPURI.createRPURI((String)rpuriString);
        if (rpuri == null) {
            log.error((Object)("Invalid relying party URI: \"" + rpuriString + "\""));
        }
        if (this.rpConfigs == null) {
            log.error((Object)"No relying party configuration objects found");
            return null;
        }
        Iterator it = this.rpConfigs.iterator();
        if (it == null) {
            log.error((Object)"No relying party configuration objects found");
            return null;
        }
        while (it.hasNext()) {
            FedSrvRPConfig rpConfig = (FedSrvRPConfig)it.next();
            if (!rpConfig.matchRPURI(rpuri)) continue;
            return rpConfig;
        }
        return null;
    }

    public FedSrvRPConfig getDefaultRPConfig() {
        return this.getRPConfig("uri:org:eclipse:alf:sso:relyingparty:anonymous:anonymous:anonymous");
    }

    public void setDefaultRPConfig(FedSrvRPConfig defaultRPConfig) {
        this.defaultRpConfig = defaultRPConfig;
    }

    public Iterator getRPConfigIterartor() {
        return this.rpConfigs.iterator();
    }

    public ExpirableMap getIssuedTokens() {
        return this.issuedTokensData;
    }

    public PKIConfig getPKIConfig() {
        return this.pkiConfig;
    }

    public void setPKIConfig(PKIConfig pkiConfig) {
        this.pkiConfig = pkiConfig;
    }

    private static class FedSrvConfigHolder {
        private static FedSrvConfig instance = new FedSrvConfig();

        private FedSrvConfigHolder() {
        }
    }
}

