/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver.config;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.RPURI;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.http.configuration.PKIConfig;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.RPURIMatcher;
import org.eclipse.alf.security.sso.common.token.saml.policy.SAML1Policy;
import org.eclipse.alf.security.sso.common.util.StringHelper;

public class FedSrvRPConfig {
    private static final Logger log = Logger.getLogger(FedSrvRPConfig.class);
    protected PKIConfig pkiConfig;
    protected ArrayList servedRPURIs;
    protected CoreConfig coreConfig;
    protected SAML1Policy tokenPolicy;
    protected String rpFriendlyName;

    public FedSrvRPConfig() {
        this.reset();
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public void reset() {
        this.pkiConfig = new PKIConfig();
        this.servedRPURIs = new ArrayList();
        this.coreConfig = new CoreConfig();
        this.tokenPolicy = new SAML1Policy();
        this.rpFriendlyName = null;
    }

    public CoreConfig getCoreConfig() {
        return this.coreConfig;
    }

    public void setCoreConfig(CoreConfig coreConfig) {
        this.coreConfig = coreConfig;
    }

    public boolean matchRPURI(RPURI rpuri) {
        if (this.servedRPURIs == null) {
            return false;
        }
        if (this.servedRPURIs.size() == 0) {
            return false;
        }
        Iterator it = this.servedRPURIs.iterator();
        if (it != null) {
            while (it.hasNext()) {
                RPURIMatcher rpuriMatcher = (RPURIMatcher)it.next();
                if (!rpuriMatcher.matches(rpuri.getType(), rpuri.getRealm(), rpuri.getInstance())) continue;
                return true;
            }
        }
        return false;
    }

    public void addServedRPURIMathcer(RPURIMatcher rpuriMatcher) {
        this.servedRPURIs.add(rpuriMatcher);
    }

    public SAML1Policy getTokenPolicy() {
        return this.tokenPolicy;
    }

    public void setTokenPolicy(SAML1Policy tokenPolicy) {
        this.tokenPolicy = tokenPolicy;
    }

    public String getRPFriendlyName() {
        if (StringHelper.isBlank((String)this.rpFriendlyName)) {
            return "";
        }
        return this.rpFriendlyName;
    }

    public void setRPFriendlyName(String rpFriendlyName) {
        this.rpFriendlyName = rpFriendlyName;
    }

    public PKIConfig getPKIConfig() {
        return this.pkiConfig;
    }

    public void setPKIConfig(PKIConfig pkiConfig) {
        this.pkiConfig = pkiConfig;
    }
}

