/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver.handler;

import java.security.Principal;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.RPURI;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.token.SSOToken;
import org.eclipse.alf.security.sso.common.token.SSOTokenFactory;
import org.eclipse.alf.security.sso.common.util.EscapeCharHelper;
import org.eclipse.alf.security.sso.common.util.SOAPHelper;
import org.eclipse.alf.security.sso.common.util.SSOHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.util.XMLHelper;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.RSTDeserializer;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.secctx.SecurityContext;
import org.eclipse.alf.security.sso.common.ws.model.WSAbstractFactory;
import org.eclipse.alf.security.sso.common.ws.model.addressing.element.EndpointReference;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.UsernameToken;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrustObjectBuilder;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.OnBehalfOf;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestSecurityToken;
import org.eclipse.alf.security.sso.server.federationserver.PageRedirector;
import org.eclipse.alf.security.sso.server.federationserver.RequestContext;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvConfig;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvRPConfig;
import org.eclipse.alf.security.sso.server.federationserver.handler.FedSvrHandlerException;
import org.eclipse.alf.security.sso.server.federationserver.secctx.SecCtxFilterToLogonAppIncoming;

public class InboundWSTrustHandler {
    private static final Logger log = Logger.getLogger(InboundWSTrustHandler.class);

    public static boolean processRequest(HttpServletRequest req, HttpServletResponse resp, RequestContext requestContext) throws ServletException {
        block27: {
            try {
                String payloadString = requestContext.getInboundWsfData().getWreq();
                OMElement payloadElement = null;
                if (StringHelper.isBlank((String)payloadString)) {
                    log.error((Object)"Missing request data: empty wreq");
                    PageRedirector.redirectAppError(req, resp, requestContext, "Malformed WS-Federation request");
                    return false;
                }
                try {
                    payloadElement = XMLHelper.toOM((String)payloadString);
                }
                catch (Throwable e) {
                    log.error((Object)("Error trying to build an OM element from wreq: [" + payloadString + "]"), e);
                    PageRedirector.redirectAppError(req, resp, requestContext, "Invalid WS-Federation request data");
                    return false;
                }
                if (SOAPHelper.isSOAPEnvelope((OMElement)payloadElement)) {
                    payloadElement = InboundWSTrustHandler.extractRSTFromSOAP(req, resp, requestContext, payloadString);
                }
                if (!SSOHelper.isRSTElement((OMElement)payloadElement)) {
                    log.error((Object)("Missing RST in wreq: [" + payloadString + "]"));
                    PageRedirector.redirectAppError(req, resp, requestContext, "Invalid WS-Federation request data");
                    return false;
                }
                RequestSecurityToken rst = InboundWSTrustHandler.extractRequestSecurityTokenFromPayload(req, resp, requestContext, payloadElement);
                if (rst == null) {
                    return false;
                }
                if (!rst.getRequestType().isKnownRequestType()) {
                    String errorMessage = "Unknown RST request type: " + rst.getRequestType().getRequestType();
                    log.error((Object)errorMessage);
                    PageRedirector.redirectAppError(req, resp, requestContext, "Invalid request - unknown request type");
                    return false;
                }
                if (!rst.getRequestType().getRequestType().equals(rst.getWSTrust().RequestTypes.getIssue()) && !rst.getRequestType().getRequestType().equals(rst.getWSTrust().RequestTypes.getCancel())) {
                    String errorMessage = "Unsupported RST request type: " + rst.getRequestType().getRequestType();
                    log.error((Object)errorMessage);
                    PageRedirector.redirectAppError(req, resp, requestContext, "Invalid request - unsupported request type");
                    return false;
                }
                String rstAppliesTo = InboundWSTrustHandler.extractAppliesToFromRST(req, resp, rst, requestContext);
                if (StringHelper.isNotBlank((String)rstAppliesTo)) {
                    RPURI rpuri = RPURI.createRPURI((String)rstAppliesTo);
                    if (rpuri == null) {
                        String errorMessage = "RST/AppliesTo contains invalid RPURI: " + rstAppliesTo;
                        log.error((Object)errorMessage);
                        PageRedirector.redirectAppError(req, resp, requestContext, "Invalid request - invalid relying party URI");
                        return false;
                    }
                    FedSrvRPConfig rpConfig = FedSrvConfig.getInstance().getRPConfig(rpuri.toString());
                    if (rpConfig == null) {
                        String errorMessage = "Cannot find configuration for relying party URI: " + rpuri;
                        log.error((Object)errorMessage);
                        PageRedirector.redirectAppError(req, resp, requestContext, "Cannot find configuration for relying party URI: " + rpuri);
                        return false;
                    }
                    requestContext.setAppliesToURI(rstAppliesTo);
                    requestContext.setRpConfig(rpConfig);
                }
                requestContext.setRST(rst);
                requestContext.setRSTElement(rst.toOM());
                if (rst.getRequestType().getRequestType().equals(rst.getWSTrust().RequestTypes.getCancel())) {
                    SSOToken cancelTarget = null;
                    try {
                        cancelTarget = SSOTokenFactory.createSSOToken((Object)rst.getCancelTarget().getSecurityToken().getNativeObject());
                    }
                    catch (SSOException e) {
                        log.error((Object)("Error processing request: could not extract cancel target: [" + payloadString + "]"));
                        PageRedirector.redirectAppError(req, resp, requestContext, "Error processing request: could not extract cancel target");
                        return false;
                    }
                    requestContext.setCancelTarget(cancelTarget);
                    String[] appliesToRelyingParties = cancelTarget.getTargetRelyingParties();
                    if (appliesToRelyingParties != null && appliesToRelyingParties.length > 0) {
                        String rpuriString = appliesToRelyingParties[0];
                        if (StringHelper.isBlank((String)rpuriString)) {
                            log.error((Object)("Error processing request: invalid cancel target: no audience restriction: [" + payloadString + "]"));
                            PageRedirector.redirectAppError(req, resp, requestContext, "Error processing request: invalid cancel target");
                            return false;
                        }
                        RPURI rpuri = RPURI.createRPURI((String)rpuriString);
                        if (rpuri == null) {
                            log.error((Object)("Error processing request: invalid cancel target: non-compatible RPURI: [" + payloadString + "]"));
                            PageRedirector.redirectAppError(req, resp, requestContext, "Error processing request: invalid cancel target");
                            return false;
                        }
                        requestContext.setAppliesToURI(rpuriString);
                        FedSrvRPConfig rpConfig = FedSrvConfig.getInstance().getRPConfig(rpuri.toString());
                        if (rpConfig == null) {
                            log.error((Object)("Error processing request: failed to find matching configuration context: [" + rpuriString + "]"));
                            PageRedirector.redirectAppError(req, resp, requestContext, "Error processing request: unknown relying party");
                            return false;
                        }
                        requestContext.setRpConfig(rpConfig);
                    }
                    break block27;
                }
                UsernameToken rstUsernameToken = InboundWSTrustHandler.extractUsernameTokenFromRSTOnBehalfOfElement(req, resp, requestContext, rst, payloadElement);
                if (rstUsernameToken != null) {
                    boolean forceLocalAuthnPrompt = requestContext.getRpConfig().getCoreConfig().getBooleanParameter("ForceLocalAuthentication", false);
                    if (forceLocalAuthnPrompt) {
                        rst.setOnBehalfOf(null);
                        requestContext.setPrincipalCredentialsAquired(false);
                    } else {
                        requestContext.setPrincipalUsername(rstUsernameToken.getUsername());
                        requestContext.setPrincipalPassword(null);
                        requestContext.setPrincipalCredentialsAquired(true);
                        requestContext.setAuthCredentialsInRST(true);
                    }
                } else {
                    Principal principal = req.getUserPrincipal();
                    if (principal != null) {
                        boolean useExistingPrincipal = requestContext.getRpConfig().getCoreConfig().getBooleanParameter("UsePrincipalUserIfPresent", false);
                        boolean isAllowedAuthnType = requestContext.getRpConfig().getCoreConfig().isAllowedPreauthenticationType(req.getAuthType());
                        if (useExistingPrincipal && isAllowedAuthnType) {
                            log.debug((Object)("Using principal user: " + principal.getName() + "/" + req.getAuthType()));
                            InboundWSTrustHandler.addPrincipalToRSTWithinOnBehalfOfElement(req, resp, principal.getName(), rst, payloadElement);
                            requestContext.setPrincipalUsername(principal.getName());
                            requestContext.setPrincipalPassword(null);
                            requestContext.setPrincipalCredentialsAquired(true);
                            requestContext.setAuthCredentialsInRST(true);
                        } else {
                            log.warn((Object)("Principal user is found on the request but authentication type is not allowed:" + principal.getName() + "/" + req.getAuthType()));
                        }
                    }
                }
            }
            catch (FedSvrHandlerException e) {
                log.error((Object)"FedSvrHandler Exception", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private static OMElement extractRSTFromSOAP(HttpServletRequest req, HttpServletResponse resp, RequestContext requestContext, String payloadString) throws FedSvrHandlerException, ServletException {
        SOAPEnvelope payloadElement = null;
        try {
            payloadElement = SOAPHelper.buildSOAPElement((String)payloadString);
        }
        catch (Throwable e) {
            log.error((Object)("Error trying to build a SOAP element from wreq: [" + payloadString + "]"), e);
            PageRedirector.redirectAppError(req, resp, requestContext, "Invalid wreq: [" + EscapeCharHelper.forHTMLTag((String)payloadString) + "]");
            throw new FedSvrHandlerException();
        }
        log.debug((Object)"Received SOAP message containing RST element");
        CoreConfig rpCoreConfig = requestContext.getRpConfig().getCoreConfig();
        try {
            RSTDeserializer soapDeserializer = new RSTDeserializer(rpCoreConfig.getAxis2ConfigurationContextReceiver());
            SecCtxFilterToLogonAppIncoming securityContext = new SecCtxFilterToLogonAppIncoming();
            soapDeserializer.setSecurityContext((SecurityContext)securityContext);
            payloadElement = soapDeserializer.receiveSOAPMessage(payloadElement.toString());
        }
        catch (SSOException e) {
            log.error((Object)"Error deserializing soap message", (Throwable)e);
            PageRedirector.redirectAppError(req, resp, requestContext, "Error deserializing SOAP message:[" + EscapeCharHelper.forHTMLTag((String)payloadString) + "]");
            throw new FedSvrHandlerException();
        }
        catch (AxisFault e) {
            log.error((Object)"Axis fault", (Throwable)e);
            PageRedirector.redirectAppError(req, resp, requestContext, "Error sending/receiving SOAP message locally:[" + EscapeCharHelper.forHTMLTag((String)payloadString) + "]");
            throw new FedSvrHandlerException();
        }
        return payloadElement;
    }

    private static RequestSecurityToken extractRequestSecurityTokenFromPayload(HttpServletRequest req, HttpServletResponse resp, RequestContext requestContext, OMElement payloadElement) throws FedSvrHandlerException, ServletException {
        RequestSecurityToken rst = null;
        try {
            rst = WSTrustObjectBuilder.buildRequestSecurityToken((OMElement)payloadElement);
        }
        catch (SSOException e) {
            log.error((Object)("Error deserializing RST element: [" + payloadElement.toString() + "]"));
            PageRedirector.redirectAppError(req, resp, requestContext, "Error deserializing RST element from wreq: [" + EscapeCharHelper.forHTMLTag((String)payloadElement.toString()) + "]");
            return null;
        }
        return rst;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static UsernameToken extractUsernameTokenFromRSTOnBehalfOfElement(HttpServletRequest req, HttpServletResponse resp, RequestContext requestContext, RequestSecurityToken rst, OMElement payloadElement) throws FedSvrHandlerException, ServletException {
        UsernameToken onBehalfOfUsernameToken = null;
        if (rst.getOnBehalfOf() == null) return onBehalfOfUsernameToken;
        if (rst.getOnBehalfOf().getSecurityToken() != null) {
            if (rst.getOnBehalfOf().getSecurityToken().getType().equals("UsernameToken")) {
                onBehalfOfUsernameToken = (UsernameToken)rst.getOnBehalfOf().getSecurityToken().getNativeObject();
                if (onBehalfOfUsernameToken.getUsername() != null && onBehalfOfUsernameToken.getUsername().trim().length() != 0) return onBehalfOfUsernameToken;
                String errMsg = "Unsuppored RST - incompatible profile - missing <Username>: [" + payloadElement.toString() + "]";
                log.error((Object)errMsg);
                PageRedirector.redirectAppError(req, resp, requestContext, errMsg);
                throw new FedSvrHandlerException();
            }
            String errMsg = "Unsuppored RST - incompatible profile - incompatible token: [" + payloadElement.toString() + "]";
            log.error((Object)errMsg);
            PageRedirector.redirectAppError(req, resp, requestContext, errMsg);
            throw new FedSvrHandlerException();
        }
        String errMsg = "Unsuppored RST - incompatible profile - missing <UsernameToken>: [" + payloadElement.toString() + "]";
        log.error((Object)errMsg);
        PageRedirector.redirectAppError(req, resp, requestContext, errMsg);
        throw new FedSvrHandlerException();
    }

    private static RequestSecurityToken addPrincipalToRSTWithinOnBehalfOfElement(HttpServletRequest req, HttpServletResponse resp, String principal, RequestSecurityToken rst, OMElement payloadElement) throws FedSvrHandlerException, ServletException {
        OnBehalfOf onBehalfOf = rst.getWSTrust().getObjectFactory().createOnBehalfOf();
        UsernameToken usernameToken = WSAbstractFactory.getWSSEObjectFactory().createUsernameToken();
        usernameToken.addId();
        usernameToken.addCreated();
        usernameToken.setUsername(principal);
        onBehalfOf.setSecurityToken((SecurityToken)usernameToken);
        rst.setOnBehalfOf(onBehalfOf);
        return rst;
    }

    private static String extractAppliesToFromRST(HttpServletRequest req, HttpServletResponse resp, RequestSecurityToken rst, RequestContext requestContext) throws FedSvrHandlerException, ServletException {
        if (rst.getAppliesTo() == null) {
            return null;
        }
        if (rst.getAppliesTo().getKnownObjectsList() == null) {
            return null;
        }
        if (rst.getAppliesTo().getKnownObjectsList().size() == 0) {
            return null;
        }
        Iterator it = rst.getAppliesTo().getKnownObjectsList().iterator();
        if (it != null) {
            while (it.hasNext()) {
                EndpointReference epr;
                Object obj = it.next();
                if (!(obj instanceof EndpointReference) || (epr = (EndpointReference)obj).getAddress() == null || epr.getAddress().getAddress() == null) continue;
                return epr.getAddress().getAddress();
            }
        }
        return null;
    }
}

