/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver.handler;

import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.cookie.CookieData;
import org.eclipse.alf.security.sso.common.http.cookie.CookieHTTPHelper;
import org.eclipse.alf.security.sso.common.http.cookie.CookieManager;
import org.eclipse.alf.security.sso.common.http.cookie.MasterCookieData;
import org.eclipse.alf.security.sso.common.token.SSOToken;
import org.eclipse.alf.security.sso.common.token.SSOTokenHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedData;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedHelper;
import org.eclipse.alf.security.sso.common.ws.model.WSAbstractFactory;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SignedSecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrustObjectFactory;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestSecurityTokenResponse;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestedTokenCancelled;
import org.eclipse.alf.security.sso.server.federationserver.PageRedirector;
import org.eclipse.alf.security.sso.server.federationserver.ProcessingException;
import org.eclipse.alf.security.sso.server.federationserver.RequestContext;
import org.eclipse.alf.security.sso.server.federationserver.processor.CancelRequestProcessor;
import org.eclipse.alf.security.sso.server.federationserver.processor.RequestProcessorResult;

public class CancelRequestHandler {
    static final Logger log = Logger.getLogger(CancelRequestHandler.class);

    public static boolean serveCancelRequest(HttpServletRequest req, HttpServletResponse resp, RequestContext requestContext) throws ServletException {
        log.info((Object)("Processing a RST/Cancel request for " + requestContext.getAppliesToURI()));
        SSOToken canceledToken = null;
        if (requestContext.getMasterCookieData() != null) {
            SignedSecurityToken securityToken = requestContext.getRST().getCancelTarget().getSecurityToken();
            if (securityToken == null) {
                PageRedirector.redirectAppError(req, resp, requestContext, "Unsuppored RST - incompatible profile - missing security token in <wst:CancelTarget>:[" + requestContext.getRSTElement().toString() + "]");
                return false;
            }
            SSOToken ssotoken = null;
            try {
                ssotoken = SSOTokenHelper.convertSecurityTokenToSSOToken((SecurityToken)securityToken);
            }
            catch (SSOException e) {
                log.error((Object)"Error converting SecurityToken into SSOToken", (Throwable)e);
                PageRedirector.redirectAppError(req, resp, requestContext, "Error converting SecurityToken into SSOToken");
                return false;
            }
            if (ssotoken.compareTo(requestContext.getMasterCookieData().getToken())) {
                WSTrustObjectFactory fac = WSAbstractFactory.getWSTObjectFactory();
                RequestSecurityTokenResponse rstr = fac.createRequestSecurityTokenResponse();
                RequestedTokenCancelled cancelConfirmation = fac.createRequestedTokenCancelled();
                rstr.setRequestedTokenCancelled(cancelConfirmation);
                requestContext.rstr = rstr;
                canceledToken = ssotoken;
            }
        }
        CancelRequestProcessor cancelProcessor = new CancelRequestProcessor();
        RequestProcessorResult result = null;
        try {
            result = cancelProcessor.process(req, resp, requestContext);
        }
        catch (ProcessingException e) {
            log.error((Object)"Cancel Request failed", (Throwable)((Object)e));
            PageRedirector.redirectAppError(req, resp, requestContext, "Logout request failed: " + e.getMessage());
            return false;
        }
        if (!result.isSuccess()) {
            log.error((Object)("Error processing issue request: " + result.getMessage()));
            PageRedirector.redirectAppError(req, resp, requestContext, "Error processing issue request: " + result.getMessage());
            return false;
        }
        requestContext.setCanceledToken(canceledToken);
        try {
            CookieManager cookieManager = requestContext.getRpConfig().getCoreConfig().getCookieManager();
            String remoteUserIP = cookieManager.getBindCookiesToUserIP() ? req.getRemoteAddr() : null;
            MasterCookieData masterCookieData = new MasterCookieData(requestContext.getAppliesToURI(), requestContext.getCancelTarget(), remoteUserIP);
            ArrayList cookies = cookieManager.createCookie((CookieData)masterCookieData);
            CookieHTTPHelper.deleteCookies((HttpServletResponse)resp, (ArrayList)cookies);
        }
        catch (SSOException e) {
            String errorMessage = "Error clearing master cookie";
            log.error((Object)errorMessage, (Throwable)e);
            PageRedirector.redirectAppError(req, resp, requestContext, "Error processing issue request: " + errorMessage);
            return false;
        }
        WSFedHelper.setWSFDataAsAttributes((HttpServletRequest)req, (WSFedData)requestContext.getOutboundWsfData());
        return true;
    }
}

