/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver.handler;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ExtendedResult;
import org.eclipse.alf.security.sso.common.RPURI;
import org.eclipse.alf.security.sso.common.http.cookie.CookieData;
import org.eclipse.alf.security.sso.common.http.cookie.CookieHTTPHelper;
import org.eclipse.alf.security.sso.common.token.SSOToken;
import org.eclipse.alf.security.sso.common.token.SSOTokenPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.SAML1Policy;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.server.federationserver.FedSrvHelper;
import org.eclipse.alf.security.sso.server.federationserver.RequestContext;

public class MasterCookieHandler {
    private static final Logger log = Logger.getLogger(MasterCookieHandler.class);

    public static boolean queryMasterCookie(HttpServletRequest req, HttpServletResponse resp, RequestContext requestContext) {
        if (requestContext == null) {
            return false;
        }
        if (StringHelper.isBlank((String)requestContext.getAppliesToURI())) {
            return false;
        }
        RPURI rpuri = RPURI.createRPURI((String)requestContext.getAppliesToURI());
        if (rpuri == null) {
            return false;
        }
        ArrayList cookiesToClear = new ArrayList();
        CookieData cookieData = FedSrvHelper.extractALFSSOCookieData(req, requestContext.getRpConfig(), rpuri.getType(), rpuri.getRealm(), cookiesToClear);
        if (cookieData != null) {
            requestContext.setMasterCookieData(null);
            SSOToken token = cookieData.getToken();
            SAML1Policy rpTokenPolicy = requestContext.getRpConfig().getTokenPolicy();
            token.setValidationPolicy((SSOTokenPolicy)rpTokenPolicy);
            ExtendedResult validationResult = token.validateToken();
            if (validationResult.isSuccess()) {
                requestContext.setMasterCookieData(cookieData);
            } else {
                if (validationResult.getCode() == 10) {
                    requestContext.setMasterCookieData(cookieData);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Loaded master cookie");
                    }
                }
                CookieHTTPHelper.deleteCookies((HttpServletResponse)resp, cookiesToClear);
            }
        }
        requestContext.setMasterCookieQueried(true);
        return true;
    }
}

