/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper.config;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;
import org.apache.xml.security.Init;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.util.FileIOHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.server.gatekeeper.config.GatekeeperConfig;
import org.eclipse.alf.security.sso.server.gatekeeper.config.GatekeeperServiceConfig;
import org.eclipse.alf.security.sso.server.gatekeeper.config.builder.GatekeeperConfigBuilder;
import org.opensaml.SAMLConfig;

public class GatekeeperConfigLoader {
    private static final Logger log = Logger.getLogger(GatekeeperConfigLoader.class);
    private boolean configrationLoaded = false;

    public synchronized boolean isConfigurationLoaded() {
        return this.configrationLoaded;
    }

    public synchronized void loadConfiguration(FilterConfig filterConfig) throws ServletException {
        if (this.configrationLoaded) {
            return;
        }
        try {
            File ssoConfigNameFile;
            boolean ssoConfigFileFound;
            Init.init();
            SAMLConfig.instance();
            String filterBasePath = FileIOHelper.normalizePath((String)(filterConfig.getServletContext().getRealPath("") + "/"));
            if (StringHelper.isBlank((String)filterBasePath)) {
                log.warn((Object)"FilterConfig.getServletContext().getRealPath() failed to return the real path. Trying filter init parameters");
                filterBasePath = filterConfig.getInitParameter("GATEKEEEPER_ROOT_PATH");
                if (StringHelper.isBlank((String)filterBasePath)) {
                    log.debug((Object)"Filter init parameter \"ROOT_PATH\" not defined. Trying context init parameters");
                    filterBasePath = filterConfig.getServletContext().getInitParameter("ROOT_PATH");
                }
            }
            if (StringHelper.isBlank((String)filterBasePath)) {
                log.error((Object)"Failed to resolve root real path - neither the servlet container returned it or the context params have it");
                throw new ServletException("Failed to resolve root real path");
            }
            File filterBasePathFile = new File(filterBasePath);
            if (!filterBasePathFile.isDirectory()) {
                log.error((Object)("Filter root real path: \"" + filterBasePath + "\" does not exist"));
                throw new ServletException("Failed to resolve root path");
            }
            try {
                filterBasePath = FileIOHelper.normalizePath((String)filterBasePathFile.getCanonicalPath()) + "/";
            }
            catch (IOException e) {
                filterBasePath = FileIOHelper.normalizePath((String)filterBasePathFile.getAbsolutePath()) + "/";
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Gatekeeper filter: using filter base path: \"" + filterBasePath + "\""));
            }
            String ssoConfigName = System.getProperty("org.eclipse.alf.security.sso.server.gatekeeper.services-config");
            String ssoConfigDir = null;
            if (StringHelper.isBlank((String)ssoConfigName)) {
                ssoConfigName = filterConfig.getInitParameter("GatekeeperConfigFile");
            }
            if (StringHelper.isBlank((String)ssoConfigName)) {
                ssoConfigName = FileIOHelper.normalizePath((String)(filterBasePath + File.separatorChar + "/WEB-INF/alfssogatekeeper/conf" + File.separatorChar + "gatekeeper-services-config.xml"));
            }
            if (!(ssoConfigFileFound = (ssoConfigNameFile = new File(ssoConfigName = FileIOHelper.normalizePath((String)ssoConfigName))).isFile())) {
                ssoConfigName = FileIOHelper.normalizePath((String)(filterBasePath + File.separatorChar + ssoConfigName));
                ssoConfigNameFile = new File(ssoConfigName);
                ssoConfigFileFound = ssoConfigNameFile.isFile();
            }
            if (!ssoConfigFileFound) {
                ssoConfigName = FileIOHelper.normalizePath((String)(filterBasePath + File.separatorChar + "/WEB-INF/alfssogatekeeper/conf" + File.separatorChar + ssoConfigName));
                ssoConfigNameFile = new File(ssoConfigName);
                ssoConfigFileFound = ssoConfigNameFile.isFile();
            }
            if (!ssoConfigFileFound) {
                String errorMessage = "Configuration file: \"" + ssoConfigName + "\" does not exist";
                log.error((Object)errorMessage);
                throw new ServletException(errorMessage);
            }
            try {
                ssoConfigDir = FileIOHelper.normalizePath((String)(new File(ssoConfigNameFile.getParent()).getCanonicalPath() + "/"));
            }
            catch (IOException e) {
                ssoConfigDir = FileIOHelper.normalizePath((String)(new File(ssoConfigNameFile.getParent()).getAbsolutePath() + "/"));
            }
            ssoConfigName = ssoConfigNameFile.getName();
            String dependenciesDir = filterConfig.getInitParameter("GatekeeperDependenciesDir");
            if (StringHelper.isNotBlank((String)dependenciesDir)) {
                File dependenciesDirFile = new File(dependenciesDir);
                if (!(dependenciesDirFile.isDirectory() || (dependenciesDirFile = new File(dependenciesDir = FileIOHelper.normalizePath((String)(filterBasePath + "/" + dependenciesDir + "/")))).isDirectory() || (dependenciesDirFile = new File(dependenciesDir = FileIOHelper.normalizePath((String)(filterBasePath + "/" + "/WEB-INF/alfssogatekeeper/lib" + "/")))).isDirectory())) {
                    dependenciesDir = null;
                    dependenciesDirFile = null;
                }
                if (StringHelper.isNotBlank((String)dependenciesDir)) {
                    try {
                        dependenciesDir = FileIOHelper.normalizePath((String)dependenciesDirFile.getCanonicalPath()) + "/";
                    }
                    catch (IOException e) {
                        dependenciesDir = FileIOHelper.normalizePath((String)dependenciesDirFile.getAbsolutePath()) + "/";
                    }
                }
            }
            GatekeeperConfigBuilder configBuilder = new GatekeeperConfigBuilder(ssoConfigDir);
            GatekeeperConfig config = null;
            try {
                config = configBuilder.build(ssoConfigName);
            }
            catch (Throwable e) {
                String fullpath = FileIOHelper.normalizePath((String)(ssoConfigDir + "/" + ssoConfigName));
                String errorMessage = "Failed to load configuration from \"" + fullpath + "\": " + e.getMessage();
                log.fatal((Object)errorMessage, e);
                throw new ServletException(errorMessage, e);
            }
            if (config == null) {
                String fullpath = FileIOHelper.normalizePath((String)(ssoConfigDir + "/" + ssoConfigName));
                String errorMessage = "Failed to load configuration from \"" + fullpath + "\"";
                log.fatal((Object)errorMessage);
                throw new ServletException(errorMessage);
            }
            Iterator it = config.getServiceConfigIterator();
            if (it != null) {
                while (it.hasNext()) {
                    GatekeeperServiceConfig serviceConfig = (GatekeeperServiceConfig)it.next();
                    CoreConfig coreConfig = serviceConfig.getCoreConfig();
                    coreConfig.setProperty("ApplicationRootAbsolutePath", filterBasePath);
                    coreConfig.setProperty("ConfigBaseAbsolutePath", ssoConfigDir);
                    coreConfig.registerSubstitutionVariable("${APPROOT_DIR}", filterBasePath);
                    coreConfig.registerSubstitutionVariable("${CONFIG_DIR}", ssoConfigDir);
                    coreConfig.registerSubstitutionVariable("${DEP_DIR}", dependenciesDir);
                    coreConfig.expandSubstitutionVariables();
                    coreConfig.setJSSEProperties();
                    coreConfig.initAxis2();
                }
            }
            GatekeeperConfig.setInstance(config);
            this.configrationLoaded = true;
        }
        catch (Throwable e) {
            String errorMessage = "Error while trying to initialize gatekeeper: " + e.getMessage();
            log.fatal((Object)errorMessage, e);
            throw new ServletException(errorMessage, e);
        }
    }
}

