/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper.config;

import org.eclipse.alf.security.sso.common.ExpirableMap;
import org.eclipse.alf.security.sso.common.token.SSOToken;
import org.eclipse.alf.security.sso.server.gatekeeper.config.GatekeeperTokenCacheData;

public class GatekeeperTokenCache {
    protected ExpirableMap tokenIdMap = new ExpirableMap();
    protected ExpirableMap tokenChecksumMap = new ExpirableMap();
    protected ExpirableMap tokenIPAddressMap = new ExpirableMap();
    private boolean tokenCacheEnabled;
    private long cacheDataExpirationIntervalInMillis = 0L;

    private GatekeeperTokenCache() {
    }

    public GatekeeperTokenCache(boolean tokenCacheEnabled, long cacheDataExpirationIntervalInMillis) {
        this.tokenCacheEnabled = tokenCacheEnabled;
        this.cacheDataExpirationIntervalInMillis = cacheDataExpirationIntervalInMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(SSOToken cookieToken, String cookieChecksum, String ipAddress) {
        String id = cookieToken.getId();
        long expires = 0L;
        if (System.currentTimeMillis() < cookieToken.getNotOnOrAfter().getTime()) {
            expires = cookieToken.getNotOnOrAfter().getTime();
        }
        if (this.tokenIdMap.hasData((Object)id)) {
            GatekeeperTokenCacheData data = (GatekeeperTokenCacheData)this.tokenIdMap.get((Object)id);
            GatekeeperTokenCache gatekeeperTokenCache = this;
            synchronized (gatekeeperTokenCache) {
                data.setCookieToken(cookieToken);
                data.setCookieChecksum(cookieChecksum);
                data.setCookieToken(cookieToken);
                data.setIpAddress(ipAddress);
                data.setExpires(expires);
                data.setIsCanceled(false);
                data.resetCacheDataExpiration();
            }
            return;
        }
        GatekeeperTokenCacheData data = new GatekeeperTokenCacheData(cookieToken, cookieChecksum, ipAddress, expires);
        data.setCacheDataExpirationIntervalInMillis(this.cacheDataExpirationIntervalInMillis);
        data.resetCacheDataExpiration();
        GatekeeperTokenCache gatekeeperTokenCache = this;
        synchronized (gatekeeperTokenCache) {
            this.tokenIdMap.put((Object)cookieToken.getId(), (Object)data, expires);
            this.tokenChecksumMap.put((Object)cookieChecksum, (Object)data, expires);
            this.tokenIPAddressMap.put((Object)ipAddress, (Object)data, expires);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToken(String tokenId) {
        if (this.tokenIdMap.containsKey((Object)this.tokenIdMap)) {
            GatekeeperTokenCache gatekeeperTokenCache = this;
            synchronized (gatekeeperTokenCache) {
                GatekeeperTokenCacheData data = (GatekeeperTokenCacheData)this.tokenIdMap.get((Object)tokenId);
                String ipAddress = data.getIpAddress();
                String cookieChecksum = data.getCookieChecksum();
                this.tokenIdMap.remove((Object)tokenId);
                this.tokenIPAddressMap.remove((Object)ipAddress);
                this.tokenChecksumMap.remove((Object)cookieChecksum);
                Object var3_3 = null;
            }
        }
    }

    public SSOToken getTokenByCookieChecksum(String checksum) {
        GatekeeperTokenCacheData data = (GatekeeperTokenCacheData)this.tokenChecksumMap.get((Object)checksum);
        if (data != null) {
            if (data.isCacheDataExpired()) {
                return null;
            }
            return data.getCookieToken();
        }
        return null;
    }

    public boolean hasValidCacheEntry(String checksum) {
        GatekeeperTokenCacheData data = (GatekeeperTokenCacheData)this.tokenChecksumMap.get((Object)checksum);
        if (data != null) {
            return !data.isCacheDataExpired();
        }
        return false;
    }

    public SSOToken getTokenById(String tokenId) {
        GatekeeperTokenCacheData data = (GatekeeperTokenCacheData)this.tokenIdMap.get((Object)tokenId);
        if (data != null) {
            return data.getCookieToken();
        }
        return null;
    }

    public SSOToken getTokenByIpAddrss(String ipAddress) {
        GatekeeperTokenCacheData data = (GatekeeperTokenCacheData)this.tokenIPAddressMap.get((Object)ipAddress);
        if (data != null) {
            return data.getCookieToken();
        }
        return null;
    }

    public String getIpAddress(String tokenId) {
        GatekeeperTokenCacheData data = (GatekeeperTokenCacheData)this.tokenIdMap.get((Object)tokenId);
        if (data != null) {
            return data.getIpAddress();
        }
        return null;
    }

    public void resetTokenCacheEntryTTL(String tokenId) {
        GatekeeperTokenCacheData data = (GatekeeperTokenCacheData)this.tokenIdMap.get((Object)tokenId);
        if (data != null) {
            data.resetCacheDataExpiration();
        }
    }

    public boolean getIsCanceled(String tokenId) {
        GatekeeperTokenCacheData data = (GatekeeperTokenCacheData)this.tokenIdMap.get((Object)tokenId);
        if (data != null) {
            return data.getIsCanceled();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsCanceled(String tokenId, boolean isCanceled) {
        GatekeeperTokenCacheData data = (GatekeeperTokenCacheData)this.tokenIdMap.get((Object)tokenId);
        if (data != null) {
            GatekeeperTokenCache gatekeeperTokenCache = this;
            synchronized (gatekeeperTokenCache) {
                data.setIsCanceled(isCanceled);
            }
        }
    }

    public long getCacheDataExpirationIntervalInMillis() {
        return this.cacheDataExpirationIntervalInMillis;
    }

    public boolean getTokenCacheEnabled() {
        return this.tokenCacheEnabled;
    }
}

