/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper.config;

import org.eclipse.alf.security.sso.common.token.SSOToken;

public class GatekeeperTokenCacheData {
    private SSOToken cookieToken;
    private String cookieChecksum;
    private String ipAddress;
    private long expires;
    private boolean isCanceled;
    private long cacheDataExpires;
    private long cacheDataExpirationIntervalInMillis = 0L;

    private GatekeeperTokenCacheData() {
    }

    public GatekeeperTokenCacheData(SSOToken cookieToken, String cookieChecksum, String ipAddress, long expires) {
        this.cookieToken = cookieToken;
        this.cookieChecksum = cookieChecksum;
        this.expires = expires;
        this.ipAddress = ipAddress;
        this.isCanceled = false;
        this.cacheDataExpires = System.currentTimeMillis() - 1L;
        this.cacheDataExpirationIntervalInMillis = 0L;
    }

    public String getCookieChecksum() {
        return this.cookieChecksum;
    }

    public void setCookieChecksum(String cookieChecksum) {
        this.cookieChecksum = cookieChecksum;
    }

    public SSOToken getCookieToken() {
        return this.cookieToken;
    }

    public void setCookieToken(SSOToken cookieToken) {
        this.cookieToken = cookieToken;
    }

    public long getExpires() {
        return this.expires;
    }

    public void setExpires(long expires) {
        this.expires = expires;
        if (this.cacheDataExpires > expires) {
            this.cacheDataExpires = expires;
        }
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public boolean getIsCanceled() {
        return this.isCanceled;
    }

    public void setIsCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    public boolean isCacheDataExpired() {
        return this.cacheDataExpires < System.currentTimeMillis();
    }

    public void resetCacheDataExpiration() {
        this.cacheDataExpires = System.currentTimeMillis() + this.cacheDataExpirationIntervalInMillis;
        if (this.cacheDataExpires > this.expires) {
            this.cacheDataExpires = this.expires;
        }
    }

    public long getCacheDataExpirationIntervalInMillis() {
        return this.cacheDataExpirationIntervalInMillis;
    }

    public void setCacheDataExpirationIntervalInMillis(long cacheDataExpirationIntervalInMillis) {
        this.cacheDataExpirationIntervalInMillis = cacheDataExpirationIntervalInMillis;
    }
}

