/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper.soap.secctx;

import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.rampart.handler.config.OutflowConfiguration;
import org.eclipse.alf.security.sso.common.keystore.KeystoreProvider;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.secctx.PWCallbackDynamic;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.secctx.SecurityContext;

public class SecCtxFedSvrRSTRequest
extends SecurityContext {
    static final Logger log = Logger.getLogger(SecCtxFedSvrRSTRequest.class);
    private boolean doSignature = false;
    private boolean doEncryption = false;
    private KeystoreProvider ksProvider = null;
    private String sigCertAlias = null;
    private String sigCertAliasPassword = null;
    private String sigCertInclusionMethod = null;
    private String encCertAlias = null;
    private String encCertAliasPassword = null;
    private String encCertInclusionMethod = null;

    public void setKeystoreProvider(KeystoreProvider ksProvider) {
        this.ksProvider = ksProvider;
    }

    public void setSigCertAlias(String sigCertAlias) {
        this.sigCertAlias = sigCertAlias;
        this.encCertAlias = sigCertAlias;
    }

    public void setSigCertAliasPassword(String sigCertAliasPassword) {
        this.sigCertAliasPassword = sigCertAliasPassword;
        this.encCertAliasPassword = sigCertAliasPassword;
    }

    public void setSigCertInclusionMethod(String sigCertInclusionMethod) {
        this.sigCertInclusionMethod = sigCertInclusionMethod;
        this.encCertInclusionMethod = sigCertInclusionMethod;
    }

    public void setDoSignature() {
        this.doSignature = true;
    }

    public void setDoEncryption() {
        this.doEncryption = true;
    }

    public OutflowConfiguration getOfc() {
        PWCallbackDynamic callback = new PWCallbackDynamic();
        String sigParts = "{Element}{http://schemas.xmlsoap.org/ws/2004/08/addressing}MessageID;{Element}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp";
        if (this.doSignature || this.doEncryption) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using keystore from \"" + this.ksProvider.getKeystoreFile() + "\""));
            }
            Properties prop1 = new Properties();
            prop1.setProperty("org.apache.ws.security.crypto.provider", "org.apache.ws.security.components.crypto.Merlin");
            prop1.setProperty("org.apache.ws.security.crypto.merlin.file", this.ksProvider.getKeystoreFile());
            prop1.setProperty("org.apache.ws.security.crypto.merlin.keystore.type", this.ksProvider.getKeystoreType());
            prop1.setProperty("org.apache.ws.security.crypto.merlin.keystore.password", this.ksProvider.getKeystorePassword());
            this.optionProperties.put("crypto_props", prop1);
        }
        OutflowConfiguration ofc = new OutflowConfiguration();
        String actionItems = "Timestamp";
        if (this.doSignature) {
            actionItems = actionItems + " Signature";
        }
        if (this.doEncryption) {
            actionItems = actionItems + " Encrypt";
        }
        ofc.setActionItems(actionItems);
        if (this.doSignature) {
            ofc.setUser(this.sigCertAlias);
            ofc.setSignatureKeyIdentifier(this.sigCertInclusionMethod);
            ofc.setSignaturePropRefId("crypto_props");
            ofc.setOptimizeParts("//xenc:EncryptedData/xenc:CipherData/xenc:CipherValue");
            ofc.setSignBody();
            callback.setSignatureKeyAlias(this.sigCertAlias.getBytes());
            callback.setKeystorePassword(this.ksProvider.getKeystorePassword());
        }
        if (this.doEncryption) {
            ofc.setEncryptBody();
            ofc.setEncryptionKeyIdentifier(this.encCertInclusionMethod);
            ofc.setEncryptionPropRefId("crypto_props");
            ofc.setEncryptionUser(this.encCertAlias);
        }
        if (this.doSignature || this.doEncryption) {
            this.ofcPasswordCallbackHandler = callback;
            this.optionProperties.put("passwordCallbackRef", callback);
        }
        this.ofc = ofc;
        return ofc;
    }
}

