/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.models;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.alf.models.ServiceFlow;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class EventMap {
    private String eventType;
    private String objectType;
    private String product;
    private String eventMatchName;
    private String productVersion;
    private String productInstance;
    private String applicationName;
    private String serviceFlowName;
    private ServiceFlow[] serviceFlows;
    private String[] serviceURLDisplay = new String[0];

    public void setServiceURLDisplay(String[] stringArray) {
        this.serviceURLDisplay = stringArray;
    }

    public static EventMap[] loadEventmapValues(Composite composite, File file) throws IOException {
        EventMap[] eventMapArray = null;
        try {
            Namespace namespace;
            SAXBuilder sAXBuilder = new SAXBuilder();
            Document document = null;
            document = file.exists() ? sAXBuilder.build(file) : new Document(new Element("ALFEventActionMap"));
            if (document.getRootElement() == null) {
                throw new JDOMException();
            }
            Element element = document.getRootElement();
            Element element2 = element.getChild("ApplicationName", namespace = element.getNamespace());
            if (element2 != null) {
                String string = element2.getText();
                List list = element.getChild("EventActions", namespace).getChildren("EventAction", namespace);
                eventMapArray = new EventMap[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    Element element3;
                    ServiceFlow serviceFlow;
                    String string2;
                    String string3;
                    eventMapArray[i] = new EventMap();
                    eventMapArray[i].applicationName = string;
                    Element element4 = (Element)list.get(i);
                    if (null == element4) continue;
                    Element element5 = element4.getChild("EventMatch", namespace);
                    if (null != element5) {
                        eventMapArray[i].eventMatchName = element5.getChildText("EventMatchName", namespace);
                        eventMapArray[i].eventType = element5.getChildText("EventType", namespace);
                        eventMapArray[i].objectType = element5.getChildText("ObjectType", namespace);
                        eventMapArray[i].product = element5.getChildText("Product", namespace);
                        eventMapArray[i].productVersion = element5.getChildText("ProductVersion", namespace);
                        eventMapArray[i].productInstance = element5.getChildText("ProductInstance", namespace);
                    }
                    Element element6 = element4.getChild("Action", namespace);
                    ArrayList<ServiceFlow> arrayList = null;
                    if (null == element6) continue;
                    arrayList = new ArrayList<ServiceFlow>();
                    List list2 = element6.getChildren("ServiceFlow", namespace);
                    if (null != list2) {
                        for (int j = 0; j < list2.size(); ++j) {
                            string3 = ((Element)list2.get(j)).getChildText("ServiceFlowName", namespace);
                            eventMapArray[i].serviceFlowName = ((Element)list2.get(j)).getChildText("ServiceFlowName", namespace);
                            string2 = ((Element)list2.get(j)).getChildText("Endpoint", namespace);
                            if (null == string2) continue;
                            serviceFlow = new ServiceFlow(string3, string2, false);
                            arrayList.add(serviceFlow);
                        }
                    }
                    if (null != (element3 = element6.getChild("SynchronousServiceFlow", namespace))) {
                        string3 = element3.getChildText("ServiceFlowName", namespace);
                        eventMapArray[i].serviceFlowName = element3.getChildText("ServiceFlowName", namespace);
                        string2 = element3.getChildText("Endpoint", namespace);
                        if (null != string2) {
                            serviceFlow = new ServiceFlow(string3, string2, true);
                            arrayList.add(serviceFlow);
                        }
                    }
                    eventMapArray[i].serviceFlows = arrayList.toArray(new ServiceFlow[arrayList.size()]);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        catch (JDOMException jDOMException) {
            MessageBox messageBox = new MessageBox(composite.getShell(), 1);
            messageBox.setMessage("ALF Event Map is not Valid . " + jDOMException.getMessage());
            messageBox.setText("ALF Event Map ");
            messageBox.open();
        }
        return eventMapArray;
    }

    public static void saveEventmapValues(EventMap[] eventMapArray, File file) {
        Namespace namespace = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        String string = "xsi:schemaLocation=http://www.eclipse.org/alf/schema/EventBase/M7 EventActionMap_M7.xsd";
        Namespace.getNamespace((String)string);
        Element element = new Element("ALFEventActionMap");
        element.addNamespaceDeclaration(namespace);
        Document document = new Document(element);
        Element element2 = new Element("ApplicationName");
        if (eventMapArray != null && eventMapArray.length > 0) {
            element2.setText(eventMapArray[0].getApplicationName());
            element.addContent((Content)element2);
        }
        Element element3 = new Element("EventActions");
        Element element4 = null;
        for (int i = 0; i < eventMapArray.length; ++i) {
            element4 = new Element("EventAction");
            Element element5 = new Element("EventMatch");
            element5.addContent((Content)new Element("EventMatchName").addContent(eventMapArray[i].eventMatchName));
            element5.addContent((Content)new Element("EventType").addContent(eventMapArray[i].eventType));
            element5.addContent((Content)new Element("ObjectType").addContent(eventMapArray[i].objectType));
            element5.addContent((Content)new Element("Product").addContent(eventMapArray[i].product));
            element5.addContent((Content)new Element("ProductVersion").addContent(eventMapArray[i].productVersion));
            element5.addContent((Content)new Element("ProductInstance").addContent(eventMapArray[i].productInstance));
            element4.addContent((Content)element5);
            if (eventMapArray[i].serviceFlows != null) {
                Element element6 = new Element("Action");
                for (int j = 0; j < eventMapArray[i].serviceFlows.length; ++j) {
                    Element element7 = null;
                    ServiceFlow serviceFlow = eventMapArray[i].serviceFlows[j];
                    element7 = serviceFlow.isSynchronous() ? new Element("SynchronousServiceFlow") : new Element("ServiceFlow");
                    Element element8 = new Element("ServiceFlowName").addContent(serviceFlow.getServiceFlowName());
                    Element element9 = new Element("Endpoint").addContent(serviceFlow.getEndPoint());
                    element7.addContent((Content)element8);
                    element7.addContent((Content)element9);
                    element6.addContent((Content)element7);
                }
                element4.addContent((Content)element6);
            }
            element3.addContent((Content)element4);
        }
        element.addContent((Content)element3);
        XMLOutputter xMLOutputter = new XMLOutputter(Format.getPrettyFormat());
        try {
            xMLOutputter.output(document, (OutputStream)new FileOutputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String string) {
        this.applicationName = string;
    }

    public ServiceFlow[] getServiceFlows() {
        ServiceFlow[] serviceFlowArray = null;
        if (null != this.serviceFlows && this.serviceFlows.length > 0) {
            serviceFlowArray = new ServiceFlow[this.serviceFlows.length];
            for (int i = 0; i < this.serviceFlows.length; ++i) {
                serviceFlowArray[i] = new ServiceFlow();
                serviceFlowArray[i].setEndPoint(this.serviceFlows[i].getEndPoint());
                serviceFlowArray[i].setServiceFlowName(this.serviceFlows[i].getServiceFlowName());
                serviceFlowArray[i].setSynchronous(this.serviceFlows[i].isSynchronous());
            }
        }
        return serviceFlowArray;
    }

    public void setServiceFlows(ServiceFlow[] serviceFlowArray) {
        this.serviceFlows = serviceFlowArray;
    }

    public String getEventMatchName() {
        return this.eventMatchName;
    }

    public void setEventMatchName(String string) {
        this.eventMatchName = string;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String string) {
        this.eventType = string;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String string) {
        this.objectType = string;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String string) {
        this.product = string;
    }

    public String getProductInstance() {
        return this.productInstance;
    }

    public void setProductInstance(String string) {
        this.productInstance = string;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String string) {
        this.productVersion = string;
    }

    public String[] getServiceURLDisplay() {
        return this.serviceURLDisplay;
    }

    public String getServiceFlowName() {
        return this.serviceFlowName;
    }

    public void setServiceFlowName(String string) {
        this.serviceFlowName = string;
    }
}

