/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http.cookie;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.servlet.http.Cookie;
import org.apache.axiom.om.util.Base64;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.RPURI;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.crypto.CryptoProvider;
import org.eclipse.alf.security.sso.common.http.cookie.CookieData;
import org.eclipse.alf.security.sso.common.token.SSOToken;
import org.eclipse.alf.security.sso.common.util.SSOHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;

public class CookieManager
implements Cloneable {
    static final Logger log = Logger.getLogger(CookieManager.class);
    public static final String ALFSSO_COOKIE_NAME = "ALF1";
    public static final int ALFSSO_COOKIE_VERSION = 0;
    public static final String ALFSSO_COOKIE_FINGERPRINT = "68f08424-3b6e-4252-b45f-6cf4862c1d21";
    public static final int DEFAULT_RP_TYPE = 1;
    protected static String ALFSSO_COOKIE_NAME_PATTERN = "^ALF1X\\d*X\\d*X(\\d*)$";
    protected int maxCookieSize = 4096;
    protected int maxCookieChunks = 5;
    protected CryptoProvider cryptoProvider = null;
    protected boolean bindCookiesToUserIP = true;
    protected boolean persistCookies = true;
    protected boolean compressCookies = true;

    public CookieManager() {
    }

    public CookieManager(CookieManager other) {
        this.maxCookieSize = other.maxCookieSize;
        this.maxCookieChunks = other.maxCookieChunks;
        this.cryptoProvider = other.cryptoProvider != null ? (CryptoProvider)other.cryptoProvider.clone() : null;
        this.bindCookiesToUserIP = other.bindCookiesToUserIP;
        this.persistCookies = other.persistCookies;
        this.compressCookies = other.persistCookies;
    }

    public int getRPTypeID(String rpType) {
        if (StringHelper.isBlank(rpType)) {
            return 1;
        }
        int typeId = rpType.hashCode();
        if (typeId < 0) {
            return -typeId;
        }
        return typeId;
    }

    public CookieData createCookieData(RPURI rpURI, SSOToken token, String remoteUserIP) throws SSOException {
        if (this.bindCookiesToUserIP) {
            return new CookieData(rpURI, token, remoteUserIP);
        }
        return new CookieData(rpURI, token, null);
    }

    protected Cookie createCookie(String name, String value, int maxAge, int version, String comment) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAge);
        cookie.setVersion(version);
        cookie.setComment(comment);
        return cookie;
    }

    protected String genCookieName(int type, int realmHash) {
        return "ALF1X" + type + "X" + realmHash + "X";
    }

    public String getCookiePayloadAsB64(CookieData cookieData) throws SSOException {
        if (cookieData == null) {
            log.error((Object)"Error creating cookie object: null cookie data");
            throw new IllegalArgumentException("Null cookie data");
        }
        String cookieDataString = cookieData.toXMLString();
        byte[] b64Source = null;
        String characterEncoding = "UTF-8";
        try {
            b64Source = cookieDataString.getBytes(characterEncoding);
        }
        catch (UnsupportedEncodingException e) {
            String errorMessage = "Unsupported character encoding: " + characterEncoding;
            log.error((Object)errorMessage, (Throwable)e);
            throw new SSOException(errorMessage, e);
        }
        if (this.compressCookies) {
            Deflater compressor = new Deflater();
            compressor.setLevel(9);
            compressor.setInput(b64Source);
            compressor.finish();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(b64Source.length);
            byte[] buf = new byte[20480];
            while (!compressor.finished()) {
                int count = compressor.deflate(buf);
                byteArrayOutputStream.write(buf, 0, count);
            }
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            b64Source = byteArrayOutputStream.toByteArray();
        }
        if (this.cryptoProvider != null) {
            b64Source = this.cryptoProvider.encrypt(b64Source);
        }
        String cookieDataB64String = Base64.encode((byte[])b64Source);
        return cookieDataB64String;
    }

    public ArrayList createCookie(CookieData cookieData) throws SSOException {
        return this.createCookie(cookieData, null);
    }

    public ArrayList createCookie(CookieData cookieData, String payload) throws SSOException {
        int endIndex;
        int beginIndex;
        String data;
        ArrayList<Cookie> retVal = new ArrayList<Cookie>();
        String cookieDataB64String = payload == null ? this.getCookiePayloadAsB64(cookieData) : payload;
        int chunks = cookieDataB64String.length() / this.getMaxCookieSize();
        if (chunks > this.getMaxCookieChunks()) {
            String errorMessage = "Cookie value too big: " + cookieDataB64String;
            log.error((Object)errorMessage);
            throw new SSOException(errorMessage);
        }
        String cookieName = this.genCookieName(this.getRPTypeID(null), StringHelper.calcHash(cookieData.getRPURI().getRealm()));
        int cookieMaxAge = -1;
        if (this.persistCookies) {
            long t1 = cookieData.getToken().getNotBefore().getTime();
            long t2 = cookieData.getToken().getNotOnOrAfter().getTime();
            cookieMaxAge = (int)((t2 - t1) / 1000L) + 1;
        }
        for (int i = 0; i < chunks + 1 && (data = cookieDataB64String.substring(beginIndex = i * this.getMaxCookieSize(), endIndex = SSOHelper.min(beginIndex + this.getMaxCookieSize(), cookieDataB64String.length()))).length() != 0; ++i) {
            Cookie cookie = this.createCookie(cookieName + (i + 1), data, cookieMaxAge, cookieData.getCookieDataVersion(), ALFSSO_COOKIE_FINGERPRINT);
            retVal.add(cookie);
        }
        return retVal;
    }

    public CookieData getFirstCookie(Cookie[] cookies, String remoteUserIP, ArrayList foundCookieObjects) throws SSOException {
        String cookieValue = null;
        if (cookies != null) {
            TreeMap<Integer, String> foundCookies = new TreeMap<Integer, String>();
            Pattern pattern = Pattern.compile(ALFSSO_COOKIE_NAME_PATTERN);
            for (int i = 0; i < cookies.length; ++i) {
                String chunknoString;
                Cookie cookie = cookies[i];
                Matcher cookieNameMatcher = pattern.matcher(cookie.getName());
                if (!cookieNameMatcher.matches() || (chunknoString = cookieNameMatcher.group()) == null) continue;
                try {
                    Integer chunkno = new Integer(chunknoString);
                    foundCookies.put(chunkno, cookie.getValue());
                    if (foundCookieObjects == null) continue;
                    foundCookieObjects.add(cookie);
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (foundCookies.size() == 0) {
                return null;
            }
            cookieValue = "";
            StringBuffer sb = new StringBuffer();
            for (Integer key : foundCookies.keySet()) {
                sb.append((String)foundCookies.get(key));
            }
            cookieValue = sb.toString();
            byte[] cookieValueBytes = Base64.decode((String)cookieValue);
            if (this.compressCookies) {
                Inflater decompressor = new Inflater();
                decompressor.setInput(cookieValueBytes);
                ByteArrayOutputStream bos = new ByteArrayOutputStream(cookieValueBytes.length);
                byte[] buf = new byte[20480];
                while (!decompressor.finished()) {
                    try {
                        int count = decompressor.inflate(buf);
                        bos.write(buf, 0, count);
                    }
                    catch (DataFormatException e) {
                        log.error((Object)"Error decompressing cookie data", (Throwable)e);
                        return null;
                    }
                }
                try {
                    bos.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                cookieValueBytes = bos.toByteArray();
            }
            if (this.cryptoProvider != null && (cookieValueBytes = this.cryptoProvider.decrypt(cookieValueBytes)) == null) {
                log.debug((Object)"Failed do decrypt cookie");
                return null;
            }
            try {
                cookieValue = new String(cookieValueBytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                String errorMsg = "Unsupported encoding while decrypting: UTF-8";
                log.error((Object)errorMsg);
                throw new SSOException(errorMsg, e);
            }
            CookieData cookieData = new CookieData().fromString(cookieValue);
            if (cookieData != null && StringHelper.isNotBlank(remoteUserIP)) {
                if (StringHelper.isBlank(cookieData.getRemoteUserIP())) {
                    log.debug((Object)"IP matching is required but cookie lacks remote user IP - no match");
                    cookieData = null;
                } else if (!remoteUserIP.trim().equals(cookieData.getRemoteUserIP().trim())) {
                    log.debug((Object)("IP matching is required and IP addresses differ:[" + remoteUserIP.trim() + "] & [" + cookieData.getRemoteUserIP().trim() + "]"));
                    cookieData = null;
                }
            }
            return cookieData;
        }
        return null;
    }

    public String extractRawCookiePayload(Cookie[] cookies, String type, String realm, String remoteUserIP, ArrayList foundCookieObjects) throws SSOException {
        if (StringHelper.isBlank(type)) {
            String errorMessage = "Empty type";
            log.error((Object)errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        if (StringHelper.isBlank(realm)) {
            String errorMessage = "Empty realm";
            log.error((Object)errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        int typeId = this.getRPTypeID(null);
        int realmHash = StringHelper.calcHash(realm);
        if (cookies == null) {
            return null;
        }
        TreeMap<Integer, String> foundCookies = new TreeMap<Integer, String>();
        Pattern pattern = Pattern.compile("^ALF1X" + typeId + "X" + realmHash + "X(\\d*)$");
        for (int i = 0; i < cookies.length; ++i) {
            String chunknoString;
            Cookie cookie = cookies[i];
            Matcher matcher = pattern.matcher(cookie.getName());
            if (!matcher.matches() || (chunknoString = matcher.group(1)) == null) continue;
            try {
                Integer chunkno = new Integer(chunknoString);
                foundCookies.put(chunkno, cookie.getValue());
                if (foundCookieObjects == null) continue;
                foundCookieObjects.add(cookie);
                continue;
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        if (foundCookies.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = foundCookies.keySet().iterator();
        if (it != null) {
            while (it.hasNext()) {
                Integer key = (Integer)it.next();
                sb.append((String)foundCookies.get(key));
            }
        }
        return sb.toString();
    }

    public CookieData getCookie(Cookie[] cookies, String type, String realm, String remoteUserIP, ArrayList foundCookieObjects) throws SSOException {
        return this.getCookie(cookies, type, realm, remoteUserIP, null, foundCookieObjects);
    }

    public CookieData getCookie(Cookie[] cookies, String type, String realm, String remoteUserIP, String rawCookiePayload, ArrayList foundCookieObjects) throws SSOException {
        String cookieValue = StringHelper.isBlank(rawCookiePayload) ? this.extractRawCookiePayload(cookies, type, realm, remoteUserIP, foundCookieObjects) : rawCookiePayload;
        if (StringHelper.isBlank(cookieValue)) {
            return null;
        }
        byte[] cookieValueBytes = Base64.decode((String)cookieValue);
        if (cookieValueBytes == null) {
            log.error((Object)("Failed to decode base64 cookie data: " + cookieValue));
            return null;
        }
        if (this.cryptoProvider != null) {
            cookieValueBytes = this.cryptoProvider.decrypt(cookieValueBytes);
        }
        if (cookieValueBytes == null) {
            return null;
        }
        if (this.compressCookies) {
            Inflater decompressor = new Inflater();
            decompressor.setInput(cookieValueBytes);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(cookieValueBytes.length);
            byte[] buf = new byte[20480];
            while (!decompressor.finished()) {
                try {
                    int count = decompressor.inflate(buf);
                    bos.write(buf, 0, count);
                }
                catch (DataFormatException e) {
                    log.error((Object)"Error decompressing cookie data", (Throwable)e);
                    return null;
                }
            }
            try {
                bos.close();
            }
            catch (IOException e) {
                String errorMessage = "Error closing stream: " + e.getMessage();
                log.error((Object)errorMessage, (Throwable)e);
                throw new SSOException(errorMessage, e);
            }
            cookieValueBytes = bos.toByteArray();
        }
        try {
            cookieValue = new String(cookieValueBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            String errorMsg = "Unsupported encoding while decrypting: UTF-8";
            log.error((Object)errorMsg);
            throw new SSOException(errorMsg, e);
        }
        CookieData cookieData = new CookieData().fromString(cookieValue);
        if (cookieData != null && StringHelper.isNotBlank(remoteUserIP)) {
            if (StringHelper.isBlank(cookieData.getRemoteUserIP())) {
                log.debug((Object)"IP matching is required but cookie lacks remote user IP - no match");
                cookieData = null;
            } else if (!remoteUserIP.trim().equals(cookieData.getRemoteUserIP().trim())) {
                log.debug((Object)("IP matching is required and IP addresses differ:[" + remoteUserIP.trim() + "] & [" + cookieData.getRemoteUserIP().trim() + "]"));
                cookieData = null;
            }
        }
        return cookieData;
    }

    public boolean getBindCookiesToUserIP() {
        return this.bindCookiesToUserIP;
    }

    public void setBindCookiesToUserIP(boolean bindCookiesToUserIP) {
        this.bindCookiesToUserIP = bindCookiesToUserIP;
    }

    public boolean getPersistCookies() {
        return this.persistCookies;
    }

    public void setPersistCookies(boolean persistCookies) {
        this.persistCookies = persistCookies;
    }

    public CryptoProvider getCryptoProvider() {
        return this.cryptoProvider;
    }

    public void setCryptoProvider(CryptoProvider cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
    }

    public int getMaxCookieSize() {
        return this.maxCookieSize;
    }

    public void setMaxCookieSize(int maxCookieSize) {
        this.maxCookieSize = maxCookieSize;
    }

    public int getMaxCookieChunks() {
        return this.maxCookieChunks;
    }

    public void setMaxCookieChunks(int maxCookieChunks) {
        this.maxCookieChunks = maxCookieChunks;
    }

    public boolean getCompressCookies() {
        return this.compressCookies;
    }

    public void setCompressCookies(boolean compressCookies) {
        this.compressCookies = compressCookies;
    }

    public Object clone() {
        return new CookieManager(this);
    }
}

