/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.policy.builder;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.token.saml.policy.AudienceRestrictionPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.BasePolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.builder.BasePolicyBuilder;
import org.eclipse.alf.security.sso.common.util.SSOHelper;

public class AudienceRestrictionPolicyBuilder
extends BasePolicyBuilder {
    private static final Logger log = Logger.getLogger(AudienceRestrictionPolicyBuilder.class);
    public static final String AUDIENCE_RESTRICTION_POLICY_LN = "AudienceRestrictionPolicy";
    public static final String RELYING_PARTY_URI_LN = "RelyingPartyURI";
    public static final String ATTR_INHERIT_FROM_CONTEXT = "inheritFromContext";
    public static final String ALLOW_UNCONFORMING_RPURIS_LN = "AllowUnconformingRPURIs";
    public static final String MATCH_TYPE_LN = "MatchType";
    public static final String ALLOW_ANONYMOUS_TYPE_LN = "AllowAnonymousType";
    public static final String MATCH_REALM_LN = "MatchRealm";
    public static final String ALLOW_ANONYMOUS_REALM_LN = "AllowAnonymousRealm";
    public static final String MATCH_INSTANCE_LN = "MatchInstance";
    public static final String ALLOW_ANONYMOUS_INSTANCE_LN = "AllowAnonymousInstance";

    public String getLocalName() {
        return AUDIENCE_RESTRICTION_POLICY_LN;
    }

    public BasePolicy build(OMElement element) throws SSOException {
        return this.build(element, null);
    }

    public BasePolicy build(OMElement element, BasePolicy basePolicy) throws SSOException {
        OMElement allowAnonymousInstanceEl;
        OMElement allowAnonymousRealmEl;
        OMElement allowAnonymousTypeEl;
        OMElement matchInstanceEl;
        OMElement matchRealmEl;
        OMElement matchTypeEl;
        if (element == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"AudienceRestrictionPolicyBuilder.build(null) called");
            }
            return basePolicy;
        }
        OMElement el = element.getFirstChildWithName(new QName(this.getLocalName()));
        if (el == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"AudienceRestrictionPolicyBuilder.build(): policy local name not found");
            }
            return basePolicy;
        }
        AudienceRestrictionPolicy audienceRestrictionPolicy = null;
        audienceRestrictionPolicy = basePolicy != null ? (AudienceRestrictionPolicy)basePolicy.clone() : new AudienceRestrictionPolicy();
        if (SSOHelper.toBoolean(this.getAttribute(el, "override"), audienceRestrictionPolicy.getOverride())) {
            log.debug((Object)"AudienceRestrictionPolicyBuilder.build(): Overriding previously defined policy");
            audienceRestrictionPolicy = new AudienceRestrictionPolicy();
        }
        audienceRestrictionPolicy.setEnforced(SSOHelper.toBoolean(this.getAttribute(el, "enforce"), audienceRestrictionPolicy.getEnforced()));
        OMElement relyingPartyURIEl = el.getFirstChildWithName(new QName(RELYING_PARTY_URI_LN));
        if (relyingPartyURIEl != null) {
            OMAttribute inheritFromContextAttr;
            audienceRestrictionPolicy.setRelyingPartyURI(relyingPartyURIEl.getText().trim());
            if (log.isDebugEnabled()) {
                log.debug((Object)("<RelyingPartyURI> element loaded:" + audienceRestrictionPolicy.getMatchType()));
            }
            if ((inheritFromContextAttr = relyingPartyURIEl.getAttribute(new QName(ATTR_INHERIT_FROM_CONTEXT))) != null) {
                audienceRestrictionPolicy.setInheritRPFromContext(SSOHelper.toBoolean(inheritFromContextAttr.getAttributeValue(), audienceRestrictionPolicy.getInheritRPFromContext()));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("<RelyingPartyURI>/@inheritFromContext attribute loaded: " + audienceRestrictionPolicy.getInheritRPFromContext()));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("<RelyingPartyURI>/@inheritFromContext attribute is missing, default used: " + audienceRestrictionPolicy.getInheritRPFromContext()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("<RelyingPartyURI> element is missing, default used: " + audienceRestrictionPolicy.getMatchType()));
        }
        OMElement allowUnconformingRPURsEl = el.getFirstChildWithName(new QName(ALLOW_UNCONFORMING_RPURIS_LN));
        if (allowUnconformingRPURsEl != null) {
            audienceRestrictionPolicy.setAllowUnconformingRPURIs(SSOHelper.toBoolean(allowUnconformingRPURsEl.getText().trim(), audienceRestrictionPolicy.getAllowUnconformingRPURIs()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("<AllowUnconformingRPURIs> element loaded:" + audienceRestrictionPolicy.getAllowUnconformingRPURIs()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("<AllowUnconformingRPURIs> element is missing, default used: " + audienceRestrictionPolicy.getAllowUnconformingRPURIs()));
        }
        if ((matchTypeEl = el.getFirstChildWithName(new QName(MATCH_TYPE_LN))) != null) {
            audienceRestrictionPolicy.setMatchType(SSOHelper.toBoolean(matchTypeEl.getText().trim(), audienceRestrictionPolicy.getMatchType()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("<MatchType> element loaded:" + audienceRestrictionPolicy.getMatchType()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("<MatchType> element is missing, default used: " + audienceRestrictionPolicy.getMatchType()));
        }
        if ((matchRealmEl = el.getFirstChildWithName(new QName(MATCH_REALM_LN))) != null) {
            audienceRestrictionPolicy.setMatchRealm(SSOHelper.toBoolean(matchRealmEl.getText().trim(), audienceRestrictionPolicy.getMatchRealm()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("<MatchRealm> element loaded:" + audienceRestrictionPolicy.getMatchRealm()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("<MatchRealm> element is missing, default used: " + audienceRestrictionPolicy.getMatchRealm()));
        }
        if ((matchInstanceEl = el.getFirstChildWithName(new QName(MATCH_INSTANCE_LN))) != null) {
            audienceRestrictionPolicy.setMatchInstance(SSOHelper.toBoolean(matchInstanceEl.getText().trim(), audienceRestrictionPolicy.getMatchInstance()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("<MatchInstance> element loaded:" + audienceRestrictionPolicy.getMatchInstance()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("<MatchInstance> element is missing, default used: " + audienceRestrictionPolicy.getMatchInstance()));
        }
        if ((allowAnonymousTypeEl = el.getFirstChildWithName(new QName(ALLOW_ANONYMOUS_TYPE_LN))) != null) {
            audienceRestrictionPolicy.setAllowAnonymousType(SSOHelper.toBoolean(allowAnonymousTypeEl.getText().trim(), audienceRestrictionPolicy.getAllowAnonymousType()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("<AllowAnonymousType> element loaded:" + audienceRestrictionPolicy.getAllowAnonymousType()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("<AllowAnonymousType> element is missing, default used: " + audienceRestrictionPolicy.getAllowAnonymousType()));
        }
        if ((allowAnonymousRealmEl = el.getFirstChildWithName(new QName(ALLOW_ANONYMOUS_REALM_LN))) != null) {
            audienceRestrictionPolicy.setAllowAnonymousRealm(SSOHelper.toBoolean(allowAnonymousRealmEl.getText().trim(), audienceRestrictionPolicy.getAllowAnonymousRealm()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("<AllowAnonymousRealm> element loaded:" + audienceRestrictionPolicy.getAllowAnonymousRealm()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("<AllowAnonymousRealm> element is missing, default used: " + audienceRestrictionPolicy.getAllowAnonymousRealm()));
        }
        if ((allowAnonymousInstanceEl = el.getFirstChildWithName(new QName(ALLOW_ANONYMOUS_INSTANCE_LN))) != null) {
            audienceRestrictionPolicy.setAllowAnonymousInstance(SSOHelper.toBoolean(allowAnonymousInstanceEl.getText().trim(), audienceRestrictionPolicy.getAllowAnonymousInstance()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("<AllowAnonymousInstance> element loaded:" + audienceRestrictionPolicy.getAllowAnonymousRealm()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("<AllowAnonymousInstance> element is missing, default used: " + audienceRestrictionPolicy.getAllowAnonymousInstance()));
        }
        return audienceRestrictionPolicy;
    }
}

