/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.policy.validator;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ExtendedResult;
import org.eclipse.alf.security.sso.common.RPURI;
import org.eclipse.alf.security.sso.common.token.SSOTokenValidationResult;
import org.eclipse.alf.security.sso.common.token.saml.SAML1Handler;
import org.eclipse.alf.security.sso.common.token.saml.policy.AudienceRestrictionPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.BasePolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.validator.BasePolicyValidator;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAudienceRestrictionCondition;
import org.opensaml.SAMLCondition;

public class AudienceRestrictionPolicyValidator
extends BasePolicyValidator {
    private static final Logger log = Logger.getLogger(AudienceRestrictionPolicyValidator.class);

    /*
     * Enabled aggressive block sorting
     */
    protected SSOTokenValidationResult match(String tokenRPURI, AudienceRestrictionPolicy policy) {
        SSOTokenValidationResult result;
        block45: {
            block43: {
                RPURI rpFromPolicy;
                RPURI rpFromToken;
                block44: {
                    block42: {
                        block40: {
                            block41: {
                                block39: {
                                    block37: {
                                        block38: {
                                            boolean matchingEnabled;
                                            result = new SSOTokenValidationResult();
                                            rpFromToken = RPURI.fromString(tokenRPURI);
                                            rpFromPolicy = RPURI.fromString(policy.getRelyingPartyURI());
                                            boolean bl = matchingEnabled = policy.getMatchType() || policy.getMatchRealm() || policy.getMatchInstance();
                                            if (rpFromToken == null) {
                                                if (StringHelper.isNotBlank(policy.getRelyingPartyURI()) && policy.getAllowUnconformingRPURIs() && !matchingEnabled) {
                                                    result.setCode(0);
                                                    return result;
                                                }
                                                log.error((Object)("Invalid token RPURI: " + tokenRPURI));
                                                result.setCode(60);
                                                result.addMessageParam(tokenRPURI);
                                                return result;
                                            }
                                            if (rpFromPolicy == null) {
                                                log.error((Object)("Invalid policy RPURI: " + policy.getRelyingPartyURI()));
                                                result.setCode(70);
                                                result.addMessageParam(policy.getRelyingPartyURI());
                                                return result;
                                            }
                                            if (!matchingEnabled) {
                                                result.setCode(0);
                                                return result;
                                            }
                                            if (!policy.getMatchType()) break block37;
                                            if (rpFromToken.getType().equals("anonymous")) {
                                                if (policy.getAllowAnonymousType()) {
                                                    if (log.isDebugEnabled()) {
                                                        log.debug((Object)"Audience restriction policy matching: allowing anonymous type");
                                                    }
                                                } else {
                                                    result.setCode(50);
                                                    if (log.isDebugEnabled()) {
                                                        log.debug((Object)"Audience restriction policy matching: anonymous type not allowed");
                                                    }
                                                    return result;
                                                }
                                            }
                                            if (!rpFromPolicy.getType().equals("*")) break block38;
                                            if (log.isDebugEnabled()) {
                                                log.debug((Object)("Audience restriction policy matching: policy rp-type is set to '*' (all): accepting: " + rpFromToken.getType()));
                                            }
                                            break block39;
                                        }
                                        if (rpFromPolicy.getType().equals(rpFromToken.getType())) {
                                            if (log.isDebugEnabled()) {
                                                log.debug((Object)("Audience restriction policy matching: rp-types match (policy, token): (" + rpFromPolicy.getType() + ", " + rpFromToken.getType()));
                                            }
                                            break block39;
                                        } else {
                                            result.setCode(50);
                                            if (log.isDebugEnabled()) {
                                                log.debug((Object)("Audience restriction policy matching: rp-types are not matching (policy, token): (" + rpFromPolicy.getType() + ", " + rpFromToken.getType()));
                                            }
                                            return result;
                                        }
                                    }
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)"Audience restriction policy matching: skipping rp-type matching due to policy settings");
                                    }
                                }
                                if (!policy.getMatchRealm()) break block40;
                                if (rpFromToken.getRealm().equals("anonymous")) {
                                    if (policy.getAllowAnonymousRealm()) {
                                        if (log.isDebugEnabled()) {
                                            log.debug((Object)"Audience restriction policy matching: allowing anonymous realm");
                                        }
                                    } else {
                                        result.setCode(50);
                                        if (log.isDebugEnabled()) {
                                            log.debug((Object)"Audience restriction policy matching: anonymous realm not allowed");
                                        }
                                        return result;
                                    }
                                }
                                if (!rpFromPolicy.getRealm().equals("*")) break block41;
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Audience restriction policy matching: policy rp-realm is set to '*' (all): accepting: " + rpFromToken.getRealm()));
                                }
                                break block42;
                            }
                            if (rpFromPolicy.getRealm().equals(rpFromToken.getRealm())) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Audience restriction policy matching: rp-realms match (policy, token): (" + rpFromPolicy.getRealm() + ", " + rpFromToken.getRealm()));
                                }
                                break block42;
                            } else {
                                result.setCode(50);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Audience restriction policy matching: rp-realms are not matching (policy, token): (" + rpFromPolicy.getRealm() + ", " + rpFromToken.getRealm()));
                                }
                                return result;
                            }
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Audience restriction policy matching: skipping rp-realm matching due to policy settings");
                        }
                    }
                    if (!policy.getMatchInstance()) break block43;
                    if (rpFromToken.getInstance().equals("anonymous")) {
                        if (policy.getAllowAnonymousInstance()) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Audience restriction policy matching: allowing anonymous instance");
                            }
                        } else {
                            result.setCode(50);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Audience restriction policy matching: anonymous instance not allowed");
                            }
                            return result;
                        }
                    }
                    if (!rpFromPolicy.getInstance().equals("*")) break block44;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Audience restriction policy matching: policy rp-instance is set to '*' (all): accepting: " + rpFromToken.getInstance()));
                    }
                    break block45;
                }
                if (rpFromPolicy.getInstance().equals(rpFromToken.getInstance())) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Audience restriction policy matching: rp-realms match (policy, token): (" + rpFromPolicy.getInstance() + ", " + rpFromToken.getInstance()));
                    }
                    break block45;
                } else {
                    result.setCode(50);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Audience restriction policy matching: rp-realms are not matching (policy, token): (" + rpFromPolicy.getInstance() + ", " + rpFromToken.getInstance()));
                    }
                    return result;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Audience restriction policy matching: skipping rp-instance matching due to policy settings");
            }
        }
        result.setCode(0);
        return result;
    }

    public ExtendedResult validate(SAML1Handler samlHandler, BasePolicy policy) {
        SSOTokenValidationResult result = new SSOTokenValidationResult();
        AudienceRestrictionPolicy audienceRestrictionPolicy = (AudienceRestrictionPolicy)policy;
        if (policy != null) {
            SAMLAssertion assertion = (SAMLAssertion)samlHandler.getNativeObject();
            Iterator conditions = assertion.getConditions();
            boolean isAudienceAllowed = true;
            block0: while (conditions.hasNext()) {
                SAMLCondition condition = (SAMLCondition)conditions.next();
                if (!(condition instanceof SAMLAudienceRestrictionCondition)) continue;
                isAudienceAllowed = false;
                Iterator audiences = ((SAMLAudienceRestrictionCondition)condition).getAudiences();
                if (!audiences.hasNext()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"SAML validation: no audience restriction listed - accept all audiences");
                    }
                    isAudienceAllowed = true;
                    break;
                }
                while (audiences.hasNext()) {
                    String audience = (String)audiences.next();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("SAML validation: processing audience restriction: " + audience));
                    }
                    if (!(result = this.match(audience, audienceRestrictionPolicy)).isSuccess()) continue;
                    isAudienceAllowed = true;
                    continue block0;
                }
            }
            if (!isAudienceAllowed) {
                log.info((Object)("SAML validation: this audience (" + audienceRestrictionPolicy.getRelyingPartyURI() + ") not on the token's audience restriction list"));
                result.setCode(50);
                return result;
            }
        }
        result.setCode(0);
        return result;
    }
}

