/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.federation.passive.remotedata;

import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class RemoteDataStorage {
    static final Logger log = Logger.getLogger(RemoteDataStorage.class);
    private Map storage = new Hashtable();
    long lastUsedKey = 1L;

    private RemoteDataStorage() {
    }

    public static synchronized RemoteDataStorage getInstance() {
        return RemoteDataStorageHolder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String add(Object data, long timeToLiveInSecods) {
        Long key;
        this.reap();
        if (data == null) {
            throw new IllegalArgumentException("Object to be stored cannot be null");
        }
        Date expires = null;
        if (timeToLiveInSecods >= 0L) {
            expires = new Date(System.currentTimeMillis() + timeToLiveInSecods * 1000L);
        }
        StorageEntry entry = new StorageEntry(data, expires);
        Map map = this.storage;
        synchronized (map) {
            do {
                if (++this.lastUsedKey != Long.MAX_VALUE) continue;
                this.lastUsedKey = 0L;
            } while (this.storage.get(key = new Long(this.lastUsedKey)) != null);
            this.storage.put(key, entry);
        }
        return key.toString();
    }

    public boolean isValidKey(String key) {
        this.reap();
        if (key == null) {
            log.error((Object)"Invalid  argument");
            throw new NullPointerException();
        }
        try {
            new Long(key);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public boolean hasData(String key) {
        this.reap();
        if (key == null) {
            log.error((Object)"Invalid  argument");
            throw new NullPointerException();
        }
        Long nkey = this.getNKeyFromKey(key);
        if (nkey != null) {
            return this.storage.get(nkey) != null;
        }
        log.error((Object)("Invalid key: \"" + key + "\""));
        return false;
    }

    public Object getDataWithRemove(String key) {
        this.reap();
        if (key == null) {
            log.error((Object)"Invalid  argument");
            throw new NullPointerException();
        }
        Long nkey = this.getNKeyFromKey(key);
        if (nkey != null) {
            StorageEntry entry = (StorageEntry)this.storage.get(nkey);
            if (entry != null) {
                this.storage.remove(nkey);
                return entry.getData();
            }
            return null;
        }
        log.error((Object)("Invalid key supplied: \"" + key + "\""));
        return null;
    }

    public Object get(String key) {
        this.reap();
        if (key == null) {
            log.error((Object)"Invalid  argument");
            throw new NullPointerException();
        }
        Long nkey = this.getNKeyFromKey(key);
        if (nkey != null) {
            StorageEntry entry = (StorageEntry)this.storage.get(nkey);
            if (entry != null) {
                return entry.getData();
            }
            return null;
        }
        log.error((Object)("Invalid key: \"" + key + "\""));
        return null;
    }

    public void removeData(String key) {
        this.reap();
        if (key == null) {
            log.error((Object)"Invalid argument: key cannot be null");
            throw new IllegalArgumentException("key cannot be null");
        }
        Long nkey = this.getNKeyFromKey(key);
        if (nkey != null) {
            this.storage.remove(nkey);
        } else {
            log.error((Object)("Invalid key supplied: \"" + nkey + "\""));
        }
    }

    protected Long getNKeyFromKey(String key) {
        Long nkey = null;
        try {
            nkey = new Long(key);
        }
        catch (NumberFormatException e) {
            log.error((Object)("Getting numeric key from key string value: \"" + key + "\""), (Throwable)e);
            return null;
        }
        return nkey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reap() {
        Map map = this.storage;
        synchronized (map) {
            Iterator entries = this.storage.entrySet().iterator();
            while (entries.hasNext()) {
                Date now;
                Map.Entry entry = entries.next();
                StorageEntry data = (StorageEntry)entry.getValue();
                if (data.getExpires() == null || (now = new Date(System.currentTimeMillis())).compareTo(data.getExpires()) <= 0) continue;
                entries.remove();
            }
        }
    }

    private class StorageEntry {
        private Object data = null;
        private Date expires = null;

        private StorageEntry() {
        }

        public StorageEntry(Object data, Date expires) {
            this.data = data;
            this.expires = expires;
        }

        public Object getData() {
            return this.data;
        }

        public Date getExpires() {
            return this.expires;
        }
    }

    private static class RemoteDataStorageHolder {
        private static RemoteDataStorage instance = new RemoteDataStorage();

        private RemoteDataStorageHolder() {
        }
    }
}

