/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ExtendedResult;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.util.SOAPFaultFactory;
import org.eclipse.alf.security.sso.common.util.SOAPHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedData;
import org.eclipse.alf.security.sso.server.gatekeeper.GatekeeperHelper;
import org.eclipse.alf.security.sso.server.gatekeeper.config.GatekeeperConfig;
import org.eclipse.alf.security.sso.server.gatekeeper.config.GatekeeperServiceConfig;
import org.eclipse.alf.security.sso.server.gatekeeper.filterloader.ALFSSOPrincipal;
import org.eclipse.alf.security.sso.server.gatekeeper.handler.FederationServicesResponseHelper;
import org.eclipse.alf.security.sso.server.gatekeeper.handler.HTTPRequestHandler;
import org.eclipse.alf.security.sso.server.gatekeeper.handler.HTTPSignOutCleanupRequestHandler;
import org.eclipse.alf.security.sso.server.gatekeeper.handler.RemoteDataRequestHandler;
import org.eclipse.alf.security.sso.server.gatekeeper.handler.SOAPRequestHandler;
import org.eclipse.alf.security.sso.server.gatekeeper.html.HTMLFactory;

public class GatekeeperRequestDispatcher {
    static final Logger log = Logger.getLogger(GatekeeperRequestDispatcher.class);

    public static ALFSSOPrincipal dispatchRequest(HttpServletRequest req, HttpServletResponse resp, int requestType) throws ServletException {
        GatekeeperConfig gatekeeperConfig = GatekeeperConfig.getInstance();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering dispatchRequest");
        }
        ALFSSOPrincipal principal = null;
        if (!gatekeeperConfig.isProtectedURI(req.getRequestURI(), req.getParameterMap())) {
            return new ALFSSOPrincipal();
        }
        RemoteDataRequestHandler remoteDataRequestHandler = new RemoteDataRequestHandler();
        if (remoteDataRequestHandler.isValidRemoteDataRequest(req)) {
            remoteDataRequestHandler.serveRequest(req, resp);
            return null;
        }
        GatekeeperServiceConfig serviceConfig = gatekeeperConfig.getServiceConfigByURI(req.getRequestURI(), req.getParameterMap());
        boolean browserRequestsEnabled = false;
        boolean soapRequestsEnabled = false;
        if (serviceConfig != null) {
            browserRequestsEnabled = serviceConfig.getProtectionLevel() == 2 || serviceConfig.getProtectionLevel() == 1;
            boolean bl = soapRequestsEnabled = serviceConfig.getProtectionLevel() == 2 || serviceConfig.getProtectionLevel() == 0;
            if (requestType == 0 && !soapRequestsEnabled) {
                SOAPEnvelope fault = SOAPFaultFactory.generateSOAP11AuthenticationFailedFault((String)"This service configuration is not configured to handle SOAP requests", null);
                SOAPFaultFactory.returnSOAPFault((HttpServletResponse)resp, (SOAPEnvelope)fault);
                return null;
            }
            if (requestType == 1 && !browserRequestsEnabled) {
                String localizedMessage = GatekeeperHelper.getLocalizedMessage("gatekeeper.error.serviceCannotHandleSOAPRequests", req.getLocale());
                HTMLFactory.setApplicationErrorResponse(req, resp, serviceConfig.getCoreConfig(), localizedMessage, null);
                return null;
            }
        } else {
            String errorMessage = "Configuration for URL \"" + req.getRequestURL() + "\" cannot be resolved";
            log.error((Object)errorMessage);
            if (requestType == 0 || SOAPHelper.isSOAPRequestProfile((HttpServletRequest)req)) {
                SOAPEnvelope fault = SOAPFaultFactory.generateSOAP11AuthenticationFailedFault((String)"Service configuration could not be found", (String)errorMessage);
                SOAPFaultFactory.returnSOAPFault((HttpServletResponse)resp, (SOAPEnvelope)fault);
                return null;
            }
            GatekeeperServiceConfig defaultServiceConfig = gatekeeperConfig.getServiceConfigByName("default");
            CoreConfig coreConfig = null;
            coreConfig = defaultServiceConfig == null ? new CoreConfig() : defaultServiceConfig.getCoreConfig();
            String localizedMessage = GatekeeperHelper.getLocalizedMessage("gatekeeper.error.serviceConfigNotFound", req.getLocale());
            String localizedDetailMessage = GatekeeperHelper.getLocalizedMessage("gatekeeper.error.serviceConfigNotFoundWithURL", req.getLocale());
            localizedDetailMessage = MessageFormat.format(localizedDetailMessage, req.getRequestURL().toString());
            HTMLFactory.setApplicationErrorResponse(req, resp, coreConfig, localizedMessage, localizedDetailMessage);
            return null;
        }
        if (serviceConfig.getType() == 0) {
            log.info((Object)("Service \"" + serviceConfig.getName() + "\" rejected request: not configured to handle incoming requests"));
            return null;
        }
        WSFedData wsfData = null;
        if (browserRequestsEnabled) {
            wsfData = FederationServicesResponseHelper.extractWSFedDataFromRequest(req, resp);
            if (wsfData != null) {
                ExtendedResult validationResult = FederationServicesResponseHelper.validateWSFedResponseProfile(wsfData);
                if (!validationResult.isSuccess()) {
                    String localizedMessage = GatekeeperHelper.getLocalizedMessage("gatekeeper.error.invalidLoginParams", req.getLocale());
                    HTMLFactory.setApplicationErrorResponse(req, resp, serviceConfig.getCoreConfig(), localizedMessage, validationResult.getMessage());
                    return null;
                }
                boolean wsfDataIsRemoted = false;
                try {
                    wsfDataIsRemoted = FederationServicesResponseHelper.isWSFedResponseDataRemoted(wsfData);
                }
                catch (SSOException e) {
                    String localizedMessage = GatekeeperHelper.getLocalizedMessage("gatekeeper.error.invalidLoginParams", req.getLocale());
                    HTMLFactory.setApplicationErrorResponse(req, resp, serviceConfig.getCoreConfig(), localizedMessage, e.getMessage());
                    return null;
                }
                if (wsfDataIsRemoted) {
                    try {
                        wsfData = FederationServicesResponseHelper.extractWSFedRemotedData(req, resp, wsfData);
                    }
                    catch (SSOException e) {
                        log.error((Object)"Error extracting remoted data", (Throwable)e);
                        HTMLFactory.setApplicationErrorResponse(req, resp, serviceConfig.getCoreConfig(), "Error in federated services login sequence", e.getMessage());
                        return null;
                    }
                }
            }
            if (wsfData != null) {
                if (!serviceConfig.matchBrowserRequestURI(req.getRequestURI(), req.getParameterMap(), true)) {
                    log.error((Object)("Request is unauthorized: no match with the browser requests service URIs: " + req.getRequestURL()));
                    return null;
                }
                if (serviceConfig.matchDMZBrowserRequestURI(req.getRequestURI(), req.getParameterMap())) {
                    return new ALFSSOPrincipal();
                }
                if (wsfData.isSigninAction()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Processing a sign-in response from WS-Federation services");
                    }
                    try {
                        principal = HTTPRequestHandler.processHTTPRequest(req, resp, serviceConfig, wsfData);
                    }
                    catch (SSOException e) {
                        log.error((Object)("Error authenticating: " + e.getMessage()), (Throwable)e);
                        String localizedMessage = GatekeeperHelper.getLocalizedMessage("gatekeeper.error.authProcessingError", req.getLocale());
                        HTMLFactory.setApplicationErrorResponse(req, resp, serviceConfig.getCoreConfig(), localizedMessage, e.getMessage());
                        return null;
                    }
                    return principal;
                }
                if (wsfData.isSignoutCleanupAction()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Processing a sign-out cleanup request from WS-Federation services");
                    }
                    try {
                        principal = HTTPSignOutCleanupRequestHandler.processSignoutCleanup(req, resp, serviceConfig, wsfData);
                    }
                    catch (SSOException e) {
                        log.error((Object)"Error signing out", (Throwable)e);
                        String localizedMessage = GatekeeperHelper.getLocalizedMessage("gatekeeper.error.signoutProcessingError", req.getLocale());
                        HTMLFactory.setApplicationErrorResponse(req, resp, serviceConfig.getCoreConfig(), localizedMessage, e.getMessage());
                        return null;
                    }
                    return principal;
                }
                if (wsfData.isSignoutCleanupAction()) {
                    // empty if block
                }
            }
        }
        if (soapRequestsEnabled && SOAPHelper.isSOAPRequestProfile((HttpServletRequest)req)) {
            SOAPEnvelope soapEnvelope = null;
            try {
                soapEnvelope = SOAPHelper.isMTOMSOAPProfile((HttpServletRequest)req) ? SOAPHelper.buildSOAPEnvelopeFromMTOM((HttpServletRequest)req, (InputStream)req.getInputStream()) : SOAPHelper.buildSOAPEnvelope((InputStream)req.getInputStream());
            }
            catch (IOException e) {
                log.error((Object)"Error processing SOAP request", (Throwable)e);
                String localizedMessage = GatekeeperHelper.getLocalizedMessage("gatekeeper.error.errorProcessingSOAPRequest", req.getLocale());
                HTMLFactory.setApplicationErrorResponse(req, resp, serviceConfig.getCoreConfig(), localizedMessage, e.getMessage());
                return null;
            }
            if (soapEnvelope != null) {
                String soapAction = SOAPHelper.extractSOAPAction((HttpServletRequest)req, (SOAPEnvelope)soapEnvelope);
                if (!serviceConfig.matchSOAPRequest(req.getRequestURI(), req.getParameterMap(), soapAction, true)) {
                    String errorMessage = "Request is unauthorized: no match with the SOAP requests service URIs: " + req.getRequestURL() + ", soap action=" + soapAction;
                    log.error((Object)errorMessage);
                    SOAPEnvelope fault = SOAPFaultFactory.generateSOAP11AuthenticationFailedFault((String)"Access to this EPR and Action not allowed", (String)errorMessage);
                    SOAPFaultFactory.returnSOAPFault((HttpServletResponse)resp, (SOAPEnvelope)fault);
                    return null;
                }
                if (serviceConfig.matchDMZSOAPRequest(req.getRequestURI(), req.getParameterMap(), soapAction)) {
                    return new ALFSSOPrincipal();
                }
                try {
                    principal = SOAPRequestHandler.processSOAPMessage(req, resp, serviceConfig, soapEnvelope);
                }
                catch (SSOException e) {
                    String errorMessage = "Error while processing SOAP request";
                    log.error((Object)errorMessage, (Throwable)e);
                    SOAPEnvelope fault = SOAPFaultFactory.generateSOAP11AuthenticationFailedFault((String)errorMessage, (String)e.getMessage());
                    SOAPFaultFactory.returnSOAPFault((HttpServletResponse)resp, (SOAPEnvelope)fault);
                    return null;
                }
                return principal;
            }
        }
        if (browserRequestsEnabled) {
            if (!serviceConfig.matchBrowserRequestURI(req.getRequestURI(), req.getParameterMap(), true)) {
                log.error((Object)("Request is unauthorized: no match with the browser requests service URIs: " + req.getRequestURL()));
                return null;
            }
            if (serviceConfig.matchDMZBrowserRequestURI(req.getRequestURI(), req.getParameterMap())) {
                return new ALFSSOPrincipal();
            }
            try {
                principal = HTTPRequestHandler.processHTTPRequest(req, resp, serviceConfig, null);
            }
            catch (SSOException e) {
                log.error((Object)"Error in authentication", (Throwable)e);
                String localizedMessage = GatekeeperHelper.getLocalizedMessage("gatekeeper.error.authProcessingError", req.getLocale());
                HTMLFactory.setApplicationErrorResponse(req, resp, serviceConfig.getCoreConfig(), localizedMessage, e.getMessage());
                return null;
            }
            return principal;
        }
        return null;
    }
}

