/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper.config;

import java.util.HashMap;
import org.eclipse.alf.security.sso.server.gatekeeper.config.GatekeeperServiceConfig;
import org.eclipse.alf.security.sso.server.gatekeeper.config.URIResolverCacheEntry;

public class URIResolverCache {
    HashMap cache = new HashMap(5000);

    public synchronized void addURI(String uri) {
        this.cache.put(uri, new URIResolverCacheEntry(uri));
    }

    public synchronized void setIsBrowser(String uri, boolean isBrowser) {
        URIResolverCacheEntry entry = (URIResolverCacheEntry)this.cache.get(uri);
        if (entry == null) {
            entry = new URIResolverCacheEntry(uri);
            this.cache.put(uri, entry);
        }
        entry.setIsBrowser(new Boolean(isBrowser));
    }

    public Boolean getIsBrowser(String uri) {
        return ((URIResolverCacheEntry)this.cache.get(uri)).getIsBrowser();
    }

    public synchronized void setIsDMZ(String uri, boolean isDMZ) {
        URIResolverCacheEntry entry = (URIResolverCacheEntry)this.cache.get(uri);
        if (entry == null) {
            entry = new URIResolverCacheEntry(uri);
            this.cache.put(uri, entry);
        }
        entry.setIsDMZ(new Boolean(isDMZ));
    }

    public Boolean getIsDMZ(String uri) {
        return ((URIResolverCacheEntry)this.cache.get(uri)).getIsDMZ();
    }

    public synchronized void setServiceConfig(String uri, GatekeeperServiceConfig serviceConfig) {
        URIResolverCacheEntry entry = (URIResolverCacheEntry)this.cache.get(uri);
        if (entry == null) {
            entry = new URIResolverCacheEntry(uri);
            this.cache.put(uri, entry);
        }
        entry.setConfig(serviceConfig);
    }

    public GatekeeperServiceConfig getServiceConfig(String uri) {
        return ((URIResolverCacheEntry)this.cache.get(uri)).getConfig();
    }

    public final boolean hasURIEntry(String uri) {
        return this.cache.get(uri) != null;
    }
}

